/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.RPC;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);

    private ServerUtils() {
    }

    public static long sanitizeUserArgs(long valueTocheck, long baseValue, long minFactor, long maxFactor) throws IllegalArgumentException {
        if (valueTocheck >= baseValue * minFactor && valueTocheck <= baseValue * maxFactor) {
            return valueTocheck;
        }
        String errMsg = String.format("%d is not within min = %d or max = %d", valueTocheck, baseValue * minFactor, baseValue * maxFactor);
        throw new IllegalArgumentException(errMsg);
    }

    public static InetSocketAddress updateRPCListenAddress(OzoneConfiguration conf, String rpcAddressKey, InetSocketAddress addr, RPC.Server rpcServer) {
        return ServerUtils.updateListenAddress(conf, rpcAddressKey, addr, rpcServer.getListenerAddress());
    }

    public static InetSocketAddress updateListenAddress(OzoneConfiguration conf, String addressKey, InetSocketAddress addr, InetSocketAddress listenAddr) {
        InetSocketAddress updatedAddr = new InetSocketAddress(addr.getHostString(), listenAddr.getPort());
        conf.set(addressKey, addr.getHostString() + ":" + listenAddr.getPort());
        return updatedAddr;
    }

    public static void releaseConnection(HttpRequestBase request) {
        if (request != null) {
            request.releaseConnection();
        }
    }

    public static File getOzoneMetaDirPath(Configuration conf) {
        String metaDirPath = conf.getTrimmed("ozone.metadata.dirs");
        Preconditions.checkNotNull((Object)metaDirPath);
        File dirPath = new File(metaDirPath);
        if (!dirPath.exists() && !dirPath.mkdirs()) {
            throw new IllegalArgumentException("Unable to create paths. Path: " + dirPath);
        }
        return dirPath;
    }

    public static void setOzoneMetaDirPath(OzoneConfiguration conf, String path) {
        conf.set("ozone.metadata.dirs", path);
    }
}

