/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.HddsConfServlet;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHttpServer.class);
    private HttpServer2 httpServer;
    private final Configuration conf;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private HttpConfig.Policy policy;
    private String name;

    public BaseHttpServer(Configuration conf, String name) throws IOException {
        this.name = name;
        this.conf = conf;
        if (this.isEnabled()) {
            this.policy = DFSUtil.getHttpPolicy((Configuration)conf);
            if (this.policy.isHttpEnabled()) {
                this.httpAddress = this.getHttpBindAddress();
            }
            if (this.policy.isHttpsEnabled()) {
                this.httpsAddress = this.getHttpsBindAddress();
            }
            HttpServer2.Builder builder = null;
            builder = DFSUtil.httpServerTemplateForNNAndJN((Configuration)conf, (InetSocketAddress)this.httpAddress, (InetSocketAddress)this.httpsAddress, (String)name, (String)this.getSpnegoPrincipal(), (String)this.getKeytabFile());
            boolean xFrameEnabled = conf.getBoolean("dfs.xframe.enabled", true);
            String xFrameOptionValue = conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
            builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
            this.httpServer = builder.build();
            this.httpServer.addServlet("conf", "/conf", HddsConfServlet.class);
        }
    }

    protected void addServlet(String servletName, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addServlet(servletName, pathSpec, clazz);
    }

    protected WebAppContext getWebAppContext() {
        return this.httpServer.getWebAppContext();
    }

    protected InetSocketAddress getBindAddress(String bindHostKey, String addressKey, String bindHostDefault, int bindPortdefault) {
        Optional bindHost = HddsUtils.getHostNameFromConfigKeys((Configuration)this.conf, (String[])new String[]{bindHostKey});
        Optional addressPort = HddsUtils.getPortNumberFromConfigKeys((Configuration)this.conf, (String[])new String[]{addressKey});
        Optional addresHost = HddsUtils.getHostNameFromConfigKeys((Configuration)this.conf, (String[])new String[]{addressKey});
        String hostName = (String)bindHost.or(addresHost).or((Object)bindHostDefault);
        return NetUtils.createSocketAddr((String)(hostName + ":" + addressPort.or((Object)bindPortdefault)));
    }

    public InetSocketAddress getHttpsBindAddress() {
        return this.getBindAddress(this.getHttpsBindHostKey(), this.getHttpsAddressKey(), this.getBindHostDefault(), this.getHttpsBindPortDefault());
    }

    public InetSocketAddress getHttpBindAddress() {
        return this.getBindAddress(this.getHttpBindHostKey(), this.getHttpAddressKey(), this.getBindHostDefault(), this.getHttpBindPortDefault());
    }

    public void start() throws IOException {
        if (this.httpServer != null && this.isEnabled()) {
            this.httpServer.start();
            this.updateConnectorAddress();
        }
    }

    private boolean isEnabled() {
        return this.conf.getBoolean(this.getEnabledKey(), true);
    }

    public void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    public void updateConnectorAddress() {
        String realAddress;
        int connIdx = 0;
        if (this.policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            realAddress = NetUtils.getHostPortString((InetSocketAddress)this.httpAddress);
            this.conf.set(this.getHttpAddressKey(), realAddress);
            LOG.info(String.format("HTTP server of %s is listening at http://%s", this.name.toUpperCase(), realAddress));
        }
        if (this.policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            realAddress = NetUtils.getHostPortString((InetSocketAddress)this.httpsAddress);
            this.conf.set(this.getHttpsAddressKey(), realAddress);
            LOG.info(String.format("HTTP server of %s is listening at https://%s", this.name.toUpperCase(), realAddress));
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    protected abstract String getHttpAddressKey();

    protected abstract String getHttpsAddressKey();

    protected abstract String getHttpBindHostKey();

    protected abstract String getHttpsBindHostKey();

    protected abstract String getBindHostDefault();

    protected abstract int getHttpBindPortDefault();

    protected abstract int getHttpsBindPortDefault();

    protected abstract String getKeytabFile();

    protected abstract String getSpnegoPrincipal();

    protected abstract String getEnabledKey();
}

