/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.client;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class HddsClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HddsClientUtils.class);
    private static final int NO_PORT = -1;
    private static final ThreadLocal<DateTimeFormatter> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz");
        return format.withZone(ZoneId.of("GMT"));
    });

    private HddsClientUtils() {
    }

    public static String formatDateTime(long millis) {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), DATE_FORMAT.get().getZone());
        return DATE_FORMAT.get().format(dateTime);
    }

    public static long formatDateTime(String date) throws ParseException {
        Preconditions.checkNotNull((Object)date, (Object)"Date string should not be null.");
        return ZonedDateTime.parse(date, DATE_FORMAT.get()).toInstant().toEpochMilli();
    }

    public static void verifyResourceName(String resName) throws IllegalArgumentException {
        if (resName == null) {
            throw new IllegalArgumentException("Bucket or Volume name is null");
        }
        if (resName.length() < 3 || resName.length() > 63) {
            throw new IllegalArgumentException("Bucket or Volume length is illegal, valid length is 3-63 characters");
        }
        if (resName.charAt(0) == '.' || resName.charAt(0) == '-') {
            throw new IllegalArgumentException("Bucket or Volume name cannot start with a period or dash");
        }
        if (resName.charAt(resName.length() - 1) == '.' || resName.charAt(resName.length() - 1) == '-') {
            throw new IllegalArgumentException("Bucket or Volume name cannot end with a period or dash");
        }
        boolean isIPv4 = true;
        int prev = 0;
        for (int index = 0; index < resName.length(); ++index) {
            char currChar = resName.charAt(index);
            if (currChar != '.') {
                boolean bl = isIPv4 = currChar >= '0' && currChar <= '9' && isIPv4;
            }
            if (currChar > 'A' && currChar < 'Z') {
                throw new IllegalArgumentException("Bucket or Volume name does not support uppercase characters");
            }
            if (currChar != '.' && currChar != '-' && (currChar < '0' || currChar > '9' && currChar < 'a' || currChar > 'z')) {
                throw new IllegalArgumentException("Bucket or Volume name has an unsupported character : " + currChar);
            }
            if (prev == 46 && currChar == '.') {
                throw new IllegalArgumentException("Bucket or Volume name should not have two contiguous periods");
            }
            if (prev == 45 && currChar == '.') {
                throw new IllegalArgumentException("Bucket or Volume name should not have period after dash");
            }
            if (prev == 46 && currChar == '-') {
                throw new IllegalArgumentException("Bucket or Volume name should not have dash after period");
            }
            prev = currChar;
        }
        if (isIPv4) {
            throw new IllegalArgumentException("Bucket or Volume name cannot be an IPv4 address or all numeric");
        }
    }

    public static void verifyResourceName(String ... resourceNames) {
        for (String resourceName : resourceNames) {
            HddsClientUtils.verifyResourceName(resourceName);
        }
    }

    public static <T> void checkNotNull(T ... references) {
        for (T ref : references) {
            Preconditions.checkNotNull(ref);
        }
    }

    public static int getListCacheSize(Configuration conf) {
        return conf.getInt("ozone.client.list.cache", 1000);
    }

    public static CloseableHttpClient newHttpClient() {
        return HddsClientUtils.newHttpClient(new Configuration());
    }

    public static CloseableHttpClient newHttpClient(Configuration conf) {
        long socketTimeout = 5000L;
        long connectionTimeout = 5000L;
        if (conf != null) {
            socketTimeout = conf.getTimeDuration("ozone.client.socket.timeout", 5000L, TimeUnit.MILLISECONDS);
            connectionTimeout = conf.getTimeDuration("ozone.client.connection.timeout", 5000L, TimeUnit.MILLISECONDS);
        }
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(Math.toIntExact(socketTimeout)).setConnectTimeout(Math.toIntExact(connectionTimeout)).build()).build();
        return client;
    }

    public static int getMaxOutstandingRequests(Configuration config) {
        return config.getInt("scm.container.client.max.outstanding.requests", 100);
    }
}

