/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerOperationClient
implements ScmClient {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerOperationClient.class);
    private static long containerSizeB = -1L;
    private final StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocationClient;
    private final XceiverClientManager xceiverClientManager;

    public ContainerOperationClient(StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocationClient, XceiverClientManager xceiverClientManager) {
        this.storageContainerLocationClient = storageContainerLocationClient;
        this.xceiverClientManager = xceiverClientManager;
    }

    public static long getContainerSizeB() {
        return containerSizeB;
    }

    public static void setContainerSizeB(long size) {
        containerSizeB = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(String owner) throws IOException {
        XceiverClientSpi client = null;
        try {
            ContainerWithPipeline containerWithPipeline = this.storageContainerLocationClient.allocateContainer(this.xceiverClientManager.getType(), this.xceiverClientManager.getFactor(), owner);
            Pipeline pipeline = containerWithPipeline.getPipeline();
            client = this.xceiverClientManager.acquireClient(pipeline, containerWithPipeline.getContainerInfo().getContainerID());
            Preconditions.checkState((pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.ALLOCATED || pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.OPEN ? 1 : 0) != 0, (Object)"Unexpected pipeline state");
            if (pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.ALLOCATED) {
                this.createPipeline(client, pipeline);
            }
            this.createContainer(client, containerWithPipeline.getContainerInfo().getContainerID());
            ContainerWithPipeline containerWithPipeline2 = containerWithPipeline;
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
            return containerWithPipeline2;
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
            throw throwable;
        }
    }

    public void createContainer(XceiverClientSpi client, long containerId) throws IOException {
        String traceID = UUID.randomUUID().toString();
        this.storageContainerLocationClient.notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container, containerId, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.create, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.begin);
        ContainerProtocolCalls.createContainer((XceiverClientSpi)client, (long)containerId, (String)traceID);
        this.storageContainerLocationClient.notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container, containerId, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.create, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.complete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container " + containerId + " leader:" + client.getPipeline().getLeader() + " machines:" + client.getPipeline().getMachines());
        }
    }

    private void createPipeline(XceiverClientSpi client, Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull((Object)pipeline.getId(), (Object)"Pipeline name cannot be null when client create flag is set.");
        client.createPipeline();
        LOG.debug("Pipeline creation successful. Pipeline: {}", (Object)pipeline.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        XceiverClientSpi client = null;
        try {
            ContainerWithPipeline containerWithPipeline = this.storageContainerLocationClient.allocateContainer(type, factor, owner);
            Pipeline pipeline = containerWithPipeline.getPipeline();
            client = this.xceiverClientManager.acquireClient(pipeline, containerWithPipeline.getContainerInfo().getContainerID());
            if (pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.ALLOCATED) {
                this.createPipeline(client, pipeline);
            }
            client = this.xceiverClientManager.acquireClient(pipeline, containerWithPipeline.getContainerInfo().getContainerID());
            this.createContainer(client, containerWithPipeline.getContainerInfo().getContainerID());
            ContainerWithPipeline containerWithPipeline2 = containerWithPipeline;
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
            return containerWithPipeline2;
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
            throw throwable;
        }
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState nodeStatuses, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        return this.storageContainerLocationClient.queryNode(nodeStatuses, queryScope, poolName);
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return this.storageContainerLocationClient.createReplicationPipeline(type, factor, nodePool);
    }

    public void close() {
        try {
            this.xceiverClientManager.close();
        }
        catch (Exception ex) {
            LOG.error("Can't close " + this.getClass().getSimpleName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainer(long containerId, Pipeline pipeline, boolean force) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClient(pipeline, containerId);
            String traceID = UUID.randomUUID().toString();
            ContainerProtocolCalls.deleteContainer((XceiverClientSpi)client, (long)containerId, (boolean)force, (String)traceID);
            this.storageContainerLocationClient.deleteContainer(containerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted container {}, leader: {}, machines: {} ", new Object[]{containerId, pipeline.getLeader(), pipeline.getMachines()});
            }
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
        }
    }

    public void deleteContainer(long containerID, boolean force) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        this.deleteContainer(containerID, info.getPipeline(), force);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerProtos.ContainerData readContainer(long containerID, Pipeline pipeline) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClient(pipeline, containerID);
            String traceID = UUID.randomUUID().toString();
            ContainerProtos.ReadContainerResponseProto response = ContainerProtocolCalls.readContainer((XceiverClientSpi)client, (long)containerID, (String)traceID);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read container {}, leader: {}, machines: {} ", new Object[]{containerID, pipeline.getLeader(), pipeline.getMachines()});
            }
            ContainerProtos.ContainerData containerData = response.getContainerData();
            return containerData;
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
        }
    }

    public ContainerProtos.ContainerData readContainer(long containerID) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        return this.readContainer(containerID, info.getPipeline());
    }

    public ContainerInfo getContainer(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainer(containerId);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainerWithPipeline(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContainer(long containerId, Pipeline pipeline) throws IOException {
        XceiverClientSpi client = null;
        try {
            LOG.debug("Close container {}", (Object)pipeline);
            client = this.xceiverClientManager.acquireClient(pipeline, containerId);
            String traceID = UUID.randomUUID().toString();
            this.storageContainerLocationClient.notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container, containerId, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.close, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.begin);
            ContainerProtocolCalls.closeContainer((XceiverClientSpi)client, (long)containerId, (String)traceID);
            this.storageContainerLocationClient.notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container, containerId, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.close, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.complete);
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client);
            }
            throw throwable;
        }
    }

    public void closeContainer(long containerId) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerId);
        Pipeline pipeline = info.getPipeline();
        this.closeContainer(containerId, pipeline);
    }

    public long getContainerSize(long containerID) throws IOException {
        long size = ContainerOperationClient.getContainerSizeB();
        if (size == -1L) {
            throw new IOException("Container size unknown!");
        }
        return size;
    }
}

