/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Storage Container Client Metrics", context="dfs")
public class XceiverClientMetrics {
    public static final String SOURCE_NAME = XceiverClientMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong pendingOps;
    private MutableCounterLong[] pendingOpsArray;
    private MutableRate[] containerOpsLatency;
    private MetricsRegistry registry;

    public XceiverClientMetrics() {
        int numEnumEntries = ContainerProtos.Type.values().length;
        this.registry = new MetricsRegistry(SOURCE_NAME);
        this.pendingOpsArray = new MutableCounterLong[numEnumEntries];
        this.containerOpsLatency = new MutableRate[numEnumEntries];
        for (int i = 0; i < numEnumEntries; ++i) {
            this.pendingOpsArray[i] = this.registry.newCounter("numPending" + ContainerProtos.Type.forNumber((int)(i + 1)), "number of pending" + ContainerProtos.Type.forNumber((int)(i + 1)) + " ops", 0L);
            this.containerOpsLatency[i] = this.registry.newRate(ContainerProtos.Type.forNumber((int)(i + 1)) + "Latency", "latency of " + ContainerProtos.Type.forNumber((int)(i + 1)) + " ops");
        }
    }

    public static XceiverClientMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (XceiverClientMetrics)ms.register(SOURCE_NAME, "Storage Container Client Metrics", (Object)new XceiverClientMetrics());
    }

    public void incrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr();
        this.pendingOpsArray[type.ordinal()].incr();
    }

    public void decrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr(-1L);
        this.pendingOpsArray[type.ordinal()].incr(-1L);
    }

    public void addContainerOpsLatency(ContainerProtos.Type type, long latencyNanos) {
        this.containerOpsLatency[type.ordinal()].add(latencyNanos);
    }

    public long getContainerOpsMetrics(ContainerProtos.Type type) {
        return this.pendingOpsArray[type.ordinal()].value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

