/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.util.Time;
import org.apache.ratis.shaded.io.grpc.Channel;
import org.apache.ratis.shaded.io.grpc.ManagedChannel;
import org.apache.ratis.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientGrpc
extends XceiverClientSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverClientGrpc.class);
    private final Pipeline pipeline;
    private final Configuration config;
    private XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub asyncStub;
    private XceiverClientMetrics metrics;
    private ManagedChannel channel;
    private final Semaphore semaphore;
    private boolean closed = false;

    public XceiverClientGrpc(Pipeline pipeline, Configuration config) {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)config);
        this.pipeline = pipeline;
        this.config = config;
        this.semaphore = new Semaphore(HddsClientUtils.getMaxOutstandingRequests(config));
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
    }

    public void connect() throws Exception {
        DatanodeDetails leader = this.pipeline.getLeader();
        int port = leader.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
        if (port == 0) {
            port = this.config.getInt("dfs.container.ipc", 9859);
        }
        LOG.debug("Connecting to server Port : " + leader.getIpAddress());
        this.channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)leader.getIpAddress(), (int)port).usePlaintext().maxInboundMessageSize(0x2000000)).build();
        this.asyncStub = XceiverClientProtocolServiceGrpc.newStub((Channel)this.channel);
    }

    @VisibleForTesting
    public boolean isConnected() {
        return !this.channel.isTerminated() && !this.channel.isShutdown();
    }

    public void close() {
        this.closed = true;
        this.channel.shutdownNow();
        try {
            this.channel.awaitTermination(60L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        try {
            return this.sendCommandAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause;
            if (e instanceof ExecutionException && (cause = e.getCause()) instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Unexpected exception during execution:" + e.getMessage());
        }
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> sendCommandAsync(final ContainerProtos.ContainerCommandRequestProto request) throws IOException, ExecutionException, InterruptedException {
        if (this.closed) {
            throw new IOException("This channel is not connected.");
        }
        if (this.channel == null || !this.isConnected()) {
            this.reconnect();
        }
        final CompletableFuture<ContainerProtos.ContainerCommandResponseProto> replyFuture = new CompletableFuture<ContainerProtos.ContainerCommandResponseProto>();
        this.semaphore.acquire();
        final long requestTime = Time.monotonicNowNanos();
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        StreamObserver requestObserver = this.asyncStub.send((StreamObserver)new StreamObserver<ContainerProtos.ContainerCommandResponseProto>(){

            public void onNext(ContainerProtos.ContainerCommandResponseProto value) {
                replyFuture.complete(value);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onError(Throwable t) {
                replyFuture.completeExceptionally(t);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onCompleted() {
                if (!replyFuture.isDone()) {
                    replyFuture.completeExceptionally(new IOException("Stream completed but no reply for request " + request));
                }
            }
        });
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        return replyFuture;
    }

    private void reconnect() throws IOException {
        try {
            this.connect();
        }
        catch (Exception e) {
            LOG.error("Error while connecting: ", (Throwable)e);
            throw new IOException(e);
        }
        if (this.channel == null || !this.isConnected()) {
            throw new IOException("This channel is not connected.");
        }
    }

    public void createPipeline() {
    }

    public void destroyPipeline() {
    }

    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }
}

