/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rpc;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.io.ChunkGroupInputStream;
import org.apache.hadoop.ozone.client.io.ChunkGroupOutputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements ClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RpcClient.class);
    private final OzoneConfiguration conf;
    private final StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocationClient;
    private final OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient;
    private final XceiverClientManager xceiverClientManager;
    private final int chunkSize;
    private final UserGroupInformation ugi;
    private final OzoneAcl.OzoneACLRights userRights;
    private final OzoneAcl.OzoneACLRights groupRights;
    private final RetryPolicy retryPolicy;

    public RpcClient(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        this.conf = new OzoneConfiguration(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.userRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.user.rights", (Enum)OMConfigKeys.OZONE_OM_USER_RIGHTS_DEFAULT);
        this.groupRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.group.rights", (Enum)OMConfigKeys.OZONE_OM_GROUP_RIGHTS_DEFAULT);
        long omVersion = RPC.getProtocolVersion(OzoneManagerProtocolPB.class);
        InetSocketAddress omAddress = OmUtils.getOmAddressForClients((Configuration)conf);
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.ozoneManagerClient = new OzoneManagerProtocolClientSideTranslatorPB((OzoneManagerProtocolPB)RPC.getProxy(OzoneManagerProtocolPB.class, (long)omVersion, (InetSocketAddress)omAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddress = this.getScmAddressForClient();
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.storageContainerLocationClient = new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        this.xceiverClientManager = new XceiverClientManager(conf);
        this.retryPolicy = OzoneClientUtils.createRetryPolicy(conf);
        int configuredChunkSize = conf.getInt("ozone.scm.chunk.size", 0x1000000);
        if (configuredChunkSize > 0x2000000) {
            LOG.warn("The chunk size ({}) is not allowed to be more than the maximum size ({}), resetting to the maximum size.", (Object)configuredChunkSize, (Object)0x2000000);
            this.chunkSize = 0x2000000;
        } else {
            this.chunkSize = configuredChunkSize;
        }
    }

    private InetSocketAddress getScmAddressForClient() throws IOException {
        List services = this.ozoneManagerClient.getServiceList();
        ServiceInfo scmInfo = (ServiceInfo)services.stream().filter(a -> a.getNodeType().equals((Object)HddsProtos.NodeType.SCM)).collect(Collectors.toList()).get(0);
        return NetUtils.createSocketAddr((String)(scmInfo.getHostname() + ":" + scmInfo.getPort(OzoneManagerProtocolProtos.ServicePort.Type.RPC)));
    }

    @Override
    public void createVolume(String volumeName) throws IOException {
        this.createVolume(volumeName, VolumeArgs.newBuilder().build());
    }

    @Override
    public void createVolume(String volumeName, VolumeArgs volArgs) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)volArgs);
        String admin = volArgs.getAdmin() == null ? this.ugi.getUserName() : volArgs.getAdmin();
        String owner = volArgs.getOwner() == null ? this.ugi.getUserName() : volArgs.getOwner();
        long quota = volArgs.getQuota() == null ? 0x1000000000000000L : OzoneQuota.parseQuota((String)volArgs.getQuota()).sizeInBytes();
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.USER, owner, this.userRights));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)owner).getGroupNames());
        userGroups.stream().forEach(group -> listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.GROUP, group, this.groupRights)));
        if (volArgs.getAcls() != null) {
            listOfAcls.addAll(volArgs.getAcls());
        }
        OmVolumeArgs.Builder builder = OmVolumeArgs.newBuilder();
        builder.setVolume(volumeName);
        builder.setAdminName(admin);
        builder.setOwnerName(owner);
        builder.setQuotaInBytes(quota);
        for (OzoneAcl ozoneAcl : listOfAcls.stream().distinct().collect(Collectors.toList())) {
            builder.addOzoneAcls(OMPBHelper.convertOzoneAcl((OzoneAcl)ozoneAcl));
        }
        LOG.info("Creating Volume: {}, with {} as owner and quota set to {} bytes.", new Object[]{volumeName, owner, quota});
        this.ozoneManagerClient.createVolume(builder.build());
    }

    @Override
    public void setVolumeOwner(String volumeName, String owner) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)owner);
        this.ozoneManagerClient.setOwner(volumeName, owner);
    }

    @Override
    public void setVolumeQuota(String volumeName, OzoneQuota quota) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)quota);
        long quotaInBytes = quota.sizeInBytes();
        this.ozoneManagerClient.setQuota(volumeName, quotaInBytes);
    }

    @Override
    public OzoneVolume getVolumeDetails(String volumeName) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        OmVolumeArgs volume = this.ozoneManagerClient.getVolumeInfo(volumeName);
        return new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()));
    }

    @Override
    public boolean checkVolumeAccess(String volumeName, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void deleteVolume(String volumeName) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        this.ozoneManagerClient.deleteVolume(volumeName);
    }

    @Override
    public List<OzoneVolume> listVolumes(String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listAllVolumes(volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @Override
    public List<OzoneVolume> listVolumes(String user, String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listVolumeByUser(user, volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @Override
    public void createBucket(String volumeName, String bucketName) throws IOException {
        this.createBucket(volumeName, bucketName, BucketArgs.newBuilder().build());
    }

    @Override
    public void createBucket(String volumeName, String bucketName, BucketArgs bucketArgs) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)bucketArgs);
        Boolean isVersionEnabled = bucketArgs.getVersioning() == null ? Boolean.FALSE : bucketArgs.getVersioning();
        StorageType storageType = bucketArgs.getStorageType() == null ? StorageType.DEFAULT : bucketArgs.getStorageType();
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.USER, this.ugi.getUserName(), this.userRights));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)this.ugi.getUserName()).getGroupNames());
        userGroups.stream().forEach(group -> listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.GROUP, group, this.groupRights)));
        if (bucketArgs.getAcls() != null) {
            listOfAcls.addAll(bucketArgs.getAcls());
        }
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(isVersionEnabled).setStorageType(storageType).setAcls(listOfAcls.stream().distinct().collect(Collectors.toList()));
        LOG.info("Creating Bucket: {}/{}, with Versioning {} and Storage Type set to {}", new Object[]{volumeName, bucketName, isVersionEnabled, storageType});
        this.ozoneManagerClient.createBucket(builder.build());
    }

    @Override
    public void addBucketAcls(String volumeName, String bucketName, List<OzoneAcl> addAcls) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull(addAcls);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setAddAcls(addAcls);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void removeBucketAcls(String volumeName, String bucketName, List<OzoneAcl> removeAcls) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull(removeAcls);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setRemoveAcls(removeAcls);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketVersioning(String volumeName, String bucketName, Boolean versioning) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)versioning);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(versioning);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketStorageType(String volumeName, String bucketName, StorageType storageType) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)storageType);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setStorageType(storageType);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void deleteBucket(String volumeName, String bucketName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        this.ozoneManagerClient.deleteBucket(volumeName, bucketName);
    }

    @Override
    public void checkBucketAccess(String volumeName, String bucketName) throws IOException {
    }

    @Override
    public OzoneBucket getBucketDetails(String volumeName, String bucketName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        OmBucketInfo bucketArgs = this.ozoneManagerClient.getBucketInfo(volumeName, bucketName);
        return new OzoneBucket((Configuration)this.conf, this, bucketArgs.getVolumeName(), bucketArgs.getBucketName(), bucketArgs.getAcls(), bucketArgs.getStorageType(), bucketArgs.getIsVersionEnabled(), bucketArgs.getCreationTime());
    }

    @Override
    public List<OzoneBucket> listBuckets(String volumeName, String bucketPrefix, String prevBucket, int maxListResult) throws IOException {
        List buckets = this.ozoneManagerClient.listBuckets(volumeName, prevBucket, bucketPrefix, maxListResult);
        return buckets.stream().map(bucket -> new OzoneBucket((Configuration)this.conf, this, bucket.getVolumeName(), bucket.getBucketName(), bucket.getAcls(), bucket.getStorageType(), bucket.getIsVersionEnabled(), bucket.getCreationTime())).collect(Collectors.toList());
    }

    @Override
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationType type, ReplicationFactor factor) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new Serializable[]{keyName, type, factor});
        String requestId = UUID.randomUUID().toString();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setType(HddsProtos.ReplicationType.valueOf((String)type.toString())).setFactor(HddsProtos.ReplicationFactor.valueOf((int)factor.getValue())).build();
        OpenKeySession openKey = this.ozoneManagerClient.openKey(keyArgs);
        ChunkGroupOutputStream groupOutputStream = new ChunkGroupOutputStream.Builder().setHandler(openKey).setXceiverClientManager(this.xceiverClientManager).setScmClient(this.storageContainerLocationClient).setOmClient(this.ozoneManagerClient).setChunkSize(this.chunkSize).setRequestID(requestId).setType(HddsProtos.ReplicationType.valueOf((String)type.toString())).setFactor(HddsProtos.ReplicationFactor.valueOf((int)factor.getValue())).setRetryPolicy(this.retryPolicy).build();
        groupOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
        return new OzoneOutputStream(groupOutputStream);
    }

    @Override
    public OzoneInputStream getKey(String volumeName, String bucketName, String keyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)keyName);
        String requestId = UUID.randomUUID().toString();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        LengthInputStream lengthInputStream = ChunkGroupInputStream.getFromOmKeyInfo(keyInfo, this.xceiverClientManager, this.storageContainerLocationClient, requestId);
        return new OzoneInputStream(lengthInputStream.getWrappedStream());
    }

    @Override
    public void deleteKey(String volumeName, String bucketName, String keyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        this.ozoneManagerClient.deleteKey(keyArgs);
    }

    @Override
    public void renameKey(String volumeName, String bucketName, String fromKeyName, String toKeyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{fromKeyName, toKeyName});
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(fromKeyName).build();
        this.ozoneManagerClient.renameKey(keyArgs, toKeyName);
    }

    @Override
    public List<OzoneKey> listKeys(String volumeName, String bucketName, String keyPrefix, String prevKey, int maxListResult) throws IOException {
        List keys = this.ozoneManagerClient.listKeys(volumeName, bucketName, prevKey, keyPrefix, maxListResult);
        return keys.stream().map(key -> new OzoneKey(key.getVolumeName(), key.getBucketName(), key.getKeyName(), key.getDataSize(), key.getCreationTime(), key.getModificationTime())).collect(Collectors.toList());
    }

    @Override
    public OzoneKeyDetails getKeyDetails(String volumeName, String bucketName, String keyName) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        ArrayList<OzoneKeyLocation> ozoneKeyLocations = new ArrayList<OzoneKeyLocation>();
        keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly().forEach(a -> ozoneKeyLocations.add(new OzoneKeyLocation(a.getContainerID(), a.getLocalID(), a.getLength(), a.getOffset())));
        return new OzoneKeyDetails(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), ozoneKeyLocations);
    }

    @Override
    public void close() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.storageContainerLocationClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.ozoneManagerClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.xceiverClientManager});
    }
}

