/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.rest.response.BucketInfo;
import org.apache.hadoop.ozone.client.rest.response.KeyInfo;
import org.apache.hadoop.ozone.client.rest.response.KeyInfoDetails;
import org.apache.hadoop.ozone.client.rest.response.KeyLocation;
import org.apache.hadoop.ozone.client.rest.response.VolumeInfo;
import org.apache.hadoop.ozone.client.rest.response.VolumeOwner;

public final class OzoneClientUtils {
    private OzoneClientUtils() {
    }

    public static BucketInfo asBucketInfo(OzoneBucket bucket) {
        BucketInfo bucketInfo = new BucketInfo(bucket.getVolumeName(), bucket.getName());
        bucketInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)bucket.getCreationTime()));
        bucketInfo.setStorageType(bucket.getStorageType());
        bucketInfo.setVersioning(OzoneConsts.Versioning.getVersioning((boolean)bucket.getVersioning()));
        bucketInfo.setAcls(bucket.getAcls());
        return bucketInfo;
    }

    public static VolumeInfo asVolumeInfo(OzoneVolume volume) {
        VolumeInfo volumeInfo = new VolumeInfo(volume.getName(), HddsClientUtils.formatDateTime((long)volume.getCreationTime()), volume.getOwner());
        volumeInfo.setQuota(OzoneQuota.getOzoneQuota((long)volume.getQuota()));
        volumeInfo.setOwner(new VolumeOwner(volume.getOwner()));
        return volumeInfo;
    }

    public static KeyInfo asKeyInfo(OzoneKey key) {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setKeyName(key.getName());
        keyInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)key.getCreationTime()));
        keyInfo.setModifiedOn(HddsClientUtils.formatDateTime((long)key.getModificationTime()));
        keyInfo.setSize(key.getDataSize());
        return keyInfo;
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        int maxRetryCount = conf.getInt("ozone.client.max.retries", 50);
        long retryInterval = conf.getTimeDuration("ozone.client.retry.interval", "200ms", TimeUnit.MILLISECONDS);
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetryCount, (long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<BlockNotCommittedException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<BlockNotCommittedException>, RetryPolicy>();
        exceptionToPolicyMap.put(BlockNotCommittedException.class, basePolicy);
        RetryPolicy retryPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        return retryPolicy;
    }

    public static KeyInfoDetails asKeyInfoDetails(OzoneKeyDetails key) {
        KeyInfoDetails keyInfo = new KeyInfoDetails();
        keyInfo.setKeyName(key.getName());
        keyInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)key.getCreationTime()));
        keyInfo.setModifiedOn(HddsClientUtils.formatDateTime((long)key.getModificationTime()));
        keyInfo.setSize(key.getDataSize());
        ArrayList keyLocations = new ArrayList();
        key.getOzoneKeyLocations().forEach(a -> keyLocations.add(new KeyLocation(a.getContainerID(), a.getLocalID(), a.getLength(), a.getOffset())));
        keyInfo.setKeyLocation(keyLocations);
        return keyInfo;
    }
}

