/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientInvocationHandler;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rest.RestClient;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientFactory.class);

    private OzoneClientFactory() {
    }

    public static OzoneClient getClient() throws IOException {
        LOG.info("Creating OzoneClient with default configuration.");
        return OzoneClientFactory.getClient((Configuration)new OzoneConfiguration());
    }

    public static OzoneClient getClient(Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        Class clazz = config.getClass("ozone.client.protocol", RpcClient.class);
        return OzoneClientFactory.getClient(OzoneClientFactory.getClientProtocol(clazz, config), config);
    }

    public static OzoneClient getRpcClient(String omHost) throws IOException {
        OzoneConfiguration config = new OzoneConfiguration();
        int port = OmUtils.getOmRpcPort((Configuration)config);
        return OzoneClientFactory.getRpcClient(omHost, port, (Configuration)config);
    }

    public static OzoneClient getRpcClient(String omHost, Integer omRpcPort) throws IOException {
        return OzoneClientFactory.getRpcClient(omHost, omRpcPort, (Configuration)new OzoneConfiguration());
    }

    public static OzoneClient getRpcClient(String omHost, Integer omRpcPort, Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)omHost);
        Preconditions.checkNotNull((Object)omRpcPort);
        Preconditions.checkNotNull((Object)config);
        config.set("ozone.om.address", omHost + ":" + omRpcPort);
        return OzoneClientFactory.getRpcClient(config);
    }

    public static OzoneClient getRpcClient(Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        return OzoneClientFactory.getClient(OzoneClientFactory.getClientProtocol(RpcClient.class, config), config);
    }

    public static OzoneClient getRestClient(String omHost) throws IOException {
        OzoneConfiguration config = new OzoneConfiguration();
        int port = OmUtils.getOmRestPort((Configuration)config);
        return OzoneClientFactory.getRestClient(omHost, port, (Configuration)config);
    }

    public static OzoneClient getRestClient(String omHost, Integer omHttpPort) throws IOException {
        return OzoneClientFactory.getRestClient(omHost, omHttpPort, (Configuration)new OzoneConfiguration());
    }

    public static OzoneClient getRestClient(String omHost, Integer omHttpPort, Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)omHost);
        Preconditions.checkNotNull((Object)omHttpPort);
        Preconditions.checkNotNull((Object)config);
        config.set("ozone.om.http-address", omHost + ":" + omHttpPort);
        return OzoneClientFactory.getRestClient(config);
    }

    public static OzoneClient getRestClient(Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        return OzoneClientFactory.getClient(OzoneClientFactory.getClientProtocol(RestClient.class, config), config);
    }

    private static OzoneClient getClient(ClientProtocol clientProtocol, Configuration config) {
        OzoneClientInvocationHandler clientHandler = new OzoneClientInvocationHandler(clientProtocol);
        ClientProtocol proxy = (ClientProtocol)Proxy.newProxyInstance(OzoneClientInvocationHandler.class.getClassLoader(), new Class[]{ClientProtocol.class}, (InvocationHandler)clientHandler);
        return new OzoneClient(config, proxy);
    }

    private static ClientProtocol getClientProtocol(Class<? extends ClientProtocol> protocolClass, Configuration config) throws IOException {
        try {
            LOG.debug("Using {} as client protocol.", (Object)protocolClass.getCanonicalName());
            Constructor<? extends ClientProtocol> ctor = protocolClass.getConstructor(Configuration.class);
            return ctor.newInstance(config);
        }
        catch (Exception e) {
            String message = "Couldn't create protocol " + protocolClass;
            LOG.error(message + " exception: ", (Throwable)e);
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e instanceof InvocationTargetException) {
                throw new IOException(message, ((InvocationTargetException)e).getTargetException());
            }
            throw new IOException(message, e);
        }
    }
}

