/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.List;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;

public final class BucketArgs {
    private List<OzoneAcl> acls;
    private Boolean versioning;
    private StorageType storageType;

    private BucketArgs(Boolean versioning, StorageType storageType, List<OzoneAcl> acls) {
        this.acls = acls;
        this.versioning = versioning;
        this.storageType = storageType;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean versioning;
        private StorageType storageType;
        private List<OzoneAcl> acls;

        public Builder setVersioning(Boolean versionFlag) {
            this.versioning = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public BucketArgs build() {
            return new BucketArgs(this.versioning, this.storageType, this.acls);
        }
    }
}

