/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeleteBlockResult;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.protocolPB.ScmBlockLocationProtocolServerSideTranslatorPB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockProtocolServer
implements ScmBlockLocationProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(SCMBlockProtocolServer.class);
    private final StorageContainerManager scm;
    private final OzoneConfiguration conf;
    private final RPC.Server blockRpcServer;
    private final InetSocketAddress blockRpcAddress;

    public SCMBlockProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.conf = conf;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 10);
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService blockProtoPbService = ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.newReflectiveBlockingService((ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.BlockingInterface)new ScmBlockLocationProtocolServerSideTranslatorPB((ScmBlockLocationProtocol)this));
        InetSocketAddress scmBlockAddress = HddsServerUtil.getScmBlockClientBindAddress((Configuration)conf);
        this.blockRpcServer = StorageContainerManager.startRpcServer(conf, scmBlockAddress, ScmBlockLocationProtocolPB.class, blockProtoPbService, handlerCount);
        this.blockRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)"ozone.scm.block.client.address", (InetSocketAddress)scmBlockAddress, (RPC.Server)this.blockRpcServer);
    }

    public RPC.Server getBlockRpcServer() {
        return this.blockRpcServer;
    }

    public InetSocketAddress getBlockRpcAddress() {
        return this.blockRpcAddress;
    }

    public void start() {
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Block Protocol", this.getBlockRpcAddress()));
        this.getBlockRpcServer().start();
    }

    public void stop() {
        try {
            LOG.info("Stopping the RPC server for Block Protocol");
            this.getBlockRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Block Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Block Protocol");
        this.getBlockRpcServer().join();
    }

    public AllocatedBlock allocateBlock(long size, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        return this.scm.getScmBlockManager().allocateBlock(size, type, factor, owner);
    }

    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        LOG.info("SCM is informed by OM to delete {} blocks", (Object)keyBlocksInfoList.size());
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>();
        for (BlockGroup keyBlocks : keyBlocksInfoList) {
            ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result resultCode;
            try {
                this.scm.getScmBlockManager().deleteBlocks(keyBlocks.getBlockIDList());
                resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.success;
            }
            catch (SCMException scmEx) {
                LOG.warn("Fail to delete block: {}", (Object)keyBlocks.getGroupID(), (Object)scmEx);
                switch (scmEx.getResult()) {
                    case CHILL_MODE_EXCEPTION: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.chillMode;
                        break;
                    }
                    case FAILED_TO_FIND_BLOCK: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.errorNotFound;
                        break;
                    }
                    default: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.unknownFailure;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                LOG.warn("Fail to delete blocks for object key: {}", (Object)keyBlocks.getGroupID(), (Object)ex);
                resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.unknownFailure;
            }
            ArrayList<DeleteBlockResult> blockResultList = new ArrayList<DeleteBlockResult>();
            for (BlockID blockKey : keyBlocks.getBlockIDList()) {
                blockResultList.add(new DeleteBlockResult(blockKey, resultCode));
            }
            results.add(new DeleteBlockGroupResult(keyBlocks.getGroupID(), blockResultList));
        }
        return results;
    }

    public ScmInfo getScmInfo() throws IOException {
        ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorage().getClusterID()).setScmId(this.scm.getScmStorage().getScmId());
        return builder.build();
    }
}

