/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines.standalone;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipelines.PipelineManager;
import org.apache.hadoop.hdds.scm.pipelines.PipelineSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneManagerImpl
extends PipelineManager {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneManagerImpl.class);
    private final NodeManager nodeManager;
    private final ContainerPlacementPolicy placementPolicy;
    private final long containerSize;
    private final Set<DatanodeDetails> standAloneMembers;

    public StandaloneManagerImpl(NodeManager nodeManager, ContainerPlacementPolicy placementPolicy, long containerSize) {
        this.nodeManager = nodeManager;
        this.placementPolicy = placementPolicy;
        this.containerSize = containerSize;
        this.standAloneMembers = new HashSet<DatanodeDetails>();
    }

    @Override
    public Pipeline allocatePipeline(HddsProtos.ReplicationFactor factor) {
        LinkedList<DatanodeDetails> newNodesList = new LinkedList<DatanodeDetails>();
        List<DatanodeDetails> datanodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        for (DatanodeDetails datanode : datanodes) {
            Preconditions.checkNotNull((Object)datanode);
            if (this.standAloneMembers.contains(datanode)) continue;
            newNodesList.add(datanode);
            if (newNodesList.size() != factor.getNumber()) continue;
            this.standAloneMembers.addAll(newNodesList);
            PipelineID pipelineID = PipelineID.valueOf((UUID)((DatanodeDetails)newNodesList.get(0)).getUuid());
            LOG.info("Allocating a new standalone pipeline of size: {} id: {}", (Object)factor.getNumber(), (Object)pipelineID);
            return PipelineSelector.newPipelineFromNodes(newNodesList, HddsProtos.ReplicationType.STAND_ALONE, HddsProtos.ReplicationFactor.ONE, pipelineID);
        }
        return null;
    }

    @Override
    public void initializePipeline(Pipeline pipeline) {
    }

    @Override
    public void processPipelineReport(Pipeline pipeline, DatanodeDetails dn) {
        super.processPipelineReport(pipeline, dn);
        this.standAloneMembers.add(dn);
    }

    @Override
    public synchronized boolean finalizePipeline(Pipeline pipeline) {
        ((PipelineManager.ActivePipelines)this.activePipelines.get(pipeline.getFactor().ordinal())).removePipeline(pipeline.getId());
        return false;
    }

    @Override
    public void closePipeline(Pipeline pipeline) throws IOException {
        for (DatanodeDetails node : pipeline.getMachines()) {
            Preconditions.checkArgument((boolean)this.standAloneMembers.remove(node));
        }
    }
}

