/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineStateManager.class);
    private final StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> stateMachine;

    PipelineStateManager() {
        HashSet<HddsProtos.LifeCycleState> finalStates = new HashSet<HddsProtos.LifeCycleState>();
        finalStates.add(HddsProtos.LifeCycleState.OPEN);
        finalStates.add(HddsProtos.LifeCycleState.CLOSED);
        this.stateMachine = new StateMachine((Enum)HddsProtos.LifeCycleState.ALLOCATED, finalStates);
        this.initializeStateMachine();
    }

    private void initializeStateMachine() {
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.ALLOCATED, (Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleEvent.CREATE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleEvent.CREATED);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleEvent.FINALIZE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.TIMEOUT);
    }

    public void updatePipelineState(Pipeline pipeline, HddsProtos.LifeCycleEvent event) throws IOException {
        HddsProtos.LifeCycleState newState;
        try {
            newState = (HddsProtos.LifeCycleState)this.stateMachine.getNextState((Enum)pipeline.getLifeCycleState(), (Enum)event);
        }
        catch (InvalidStateTransitionException ex) {
            String error = String.format("Failed to update pipeline state %s, reason: invalid state transition from state: %s upon event: %s.", pipeline.getId(), pipeline.getLifeCycleState(), event);
            LOG.error(error);
            throw new SCMException(error, SCMException.ResultCodes.FAILED_TO_CHANGE_PIPELINE_STATE);
        }
        Preconditions.checkNotNull((Object)newState);
        Preconditions.checkNotNull((Object)pipeline);
        pipeline.setLifeCycleState(newState);
    }
}

