/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipelines.PipelineSelector;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineReportHandler.class);
    private final PipelineSelector pipelineSelector;

    public PipelineReportHandler(PipelineSelector pipelineSelector) {
        Preconditions.checkNotNull((Object)pipelineSelector);
        this.pipelineSelector = pipelineSelector;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode, EventPublisher publisher) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        DatanodeDetails dn = pipelineReportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        Preconditions.checkNotNull((Object)dn, (Object)"Pipeline Report is missing DatanodeDetails.");
        LOGGER.trace("Processing pipeline report for dn: {}", (Object)dn);
        this.pipelineSelector.processPipelineReport(dn, pipelineReport);
    }
}

