/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineManager {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineManager.class);
    protected final ArrayList<ActivePipelines> activePipelines = new ArrayList();

    public PipelineManager() {
        for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
            this.activePipelines.add(factor.ordinal(), new ActivePipelines());
        }
    }

    public final synchronized PipelineID getPipeline(HddsProtos.ReplicationFactor replicationFactor, HddsProtos.ReplicationType replicationType) {
        PipelineID id = this.activePipelines.get(replicationFactor.ordinal()).findOpenPipeline();
        if (id != null) {
            LOG.debug("re-used pipeline:{} for container with replicationType:{} replicationFactor:{}", new Object[]{id, replicationType, replicationFactor});
        }
        if (id == null) {
            LOG.error("Get pipeline call failed. We are not able to find operational pipeline.");
            return null;
        }
        return id;
    }

    void addOpenPipeline(Pipeline pipeline) {
        this.activePipelines.get(pipeline.getFactor().ordinal()).addPipeline(pipeline.getId());
    }

    public abstract Pipeline allocatePipeline(HddsProtos.ReplicationFactor var1);

    public abstract void initializePipeline(Pipeline var1) throws IOException;

    public void processPipelineReport(Pipeline pipeline, DatanodeDetails dn) {
        if (pipeline.addMember(dn) && pipeline.getDatanodes().size() == pipeline.getFactor().getNumber() && pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.OPEN) {
            this.addOpenPipeline(pipeline);
        }
    }

    public Pipeline createPipeline(HddsProtos.ReplicationFactor replicationFactor, HddsProtos.ReplicationType replicationType) throws IOException {
        Pipeline pipeline = this.allocatePipeline(replicationFactor);
        if (pipeline != null) {
            LOG.debug("created new pipeline:{} for container with replicationType:{} replicationFactor:{}", new Object[]{pipeline.getId(), replicationType, replicationFactor});
        }
        return pipeline;
    }

    public abstract boolean finalizePipeline(Pipeline var1);

    public abstract void closePipeline(Pipeline var1) throws IOException;

    public static class ActivePipelines {
        private final List<PipelineID> activePipelines = new LinkedList<PipelineID>();
        private final AtomicInteger pipelineIndex = new AtomicInteger(0);

        ActivePipelines() {
        }

        void addPipeline(PipelineID pipelineID) {
            if (!this.activePipelines.contains(pipelineID)) {
                this.activePipelines.add(pipelineID);
            }
        }

        public void removePipeline(PipelineID pipelineID) {
            this.activePipelines.remove(pipelineID);
        }

        PipelineID findOpenPipeline() {
            if (this.activePipelines.size() == 0) {
                LOG.error("No Operational pipelines found. Returning null.");
                return null;
            }
            return this.activePipelines.get(this.getNextIndex());
        }

        private int getNextIndex() {
            return this.pipelineIndex.incrementAndGet() % this.activePipelines.size();
        }
    }
}

