/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineActionEventHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(PipelineActionEventHandler.class);

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode report, EventPublisher publisher) {
        block3: for (StorageContainerDatanodeProtocolProtos.PipelineAction action : ((StorageContainerDatanodeProtocolProtos.PipelineActionsProto)report.getReport()).getPipelineActionsList()) {
            switch (action.getAction()) {
                case CLOSE: {
                    PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)action.getClosePipeline().getPipelineID());
                    LOG.info("Closing pipeline " + pipelineID + " for reason:" + action.getClosePipeline().getDetailedReason());
                    publisher.fireEvent(SCMEvents.PIPELINE_CLOSE, (Object)pipelineID);
                    continue block3;
                }
            }
            LOG.error("unknown pipeline action:{}" + action.getAction());
        }
    }
}

