/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.node.states.Node2ObjectsMap;

public class Node2PipelineMap
extends Node2ObjectsMap<PipelineID> {
    public Set<PipelineID> getPipelines(UUID datanode) {
        return this.getObjects(datanode);
    }

    public synchronized void addPipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getDatanodes().values()) {
            UUID dnId = details.getUuid();
            this.dn2ObjectMap.computeIfAbsent(dnId, k -> new HashSet()).add(pipeline.getId());
        }
    }

    public synchronized void removePipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getDatanodes().values()) {
            UUID dnId = details.getUuid();
            this.dn2ObjectMap.computeIfPresent(dnId, (k, v) -> {
                v.remove(pipeline.getId());
                return v;
            });
        }
    }
}

