/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.states.Node2ContainerMap;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadNodeHandler
implements EventHandler<DatanodeDetails> {
    private final Node2ContainerMap node2ContainerMap;
    private final ContainerStateManager containerStateManager;
    private static final Logger LOG = LoggerFactory.getLogger(DeadNodeHandler.class);

    public DeadNodeHandler(Node2ContainerMap node2ContainerMap, ContainerStateManager containerStateManager) {
        this.node2ContainerMap = node2ContainerMap;
        this.containerStateManager = containerStateManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        Set<ContainerID> containers = this.node2ContainerMap.getContainers(datanodeDetails.getUuid());
        if (containers == null) {
            LOG.info("There's no containers in dead datanode {}, no replica will be removed from the in-memory state.", (Object)datanodeDetails.getUuid());
            return;
        }
        LOG.info("Datanode {}  is dead. Removing replications from the in-memory state.", (Object)datanodeDetails.getUuid());
        for (ContainerID container : containers) {
            try {
                ReplicationRequest replicationRequest;
                this.containerStateManager.removeContainerReplica(container, datanodeDetails);
                if (this.containerStateManager.isOpen(container) || (replicationRequest = this.containerStateManager.checkReplicationState(container)) == null) continue;
                publisher.fireEvent(SCMEvents.REPLICATE_CONTAINER, (Object)replicationRequest);
            }
            catch (SCMException e) {
                LOG.error("Can't remove container from containerStateMap {}", (Object)container.getId(), (Object)e);
            }
        }
    }
}

