/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.Mapping;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationActivityStatus;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.states.Node2ContainerMap;
import org.apache.hadoop.hdds.scm.node.states.ReportResult;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final Node2ContainerMap node2ContainerMap;
    private final Mapping containerMapping;
    private ContainerStateManager containerStateManager;
    private ReplicationActivityStatus replicationStatus;

    public ContainerReportHandler(Mapping containerMapping, Node2ContainerMap node2ContainerMap, ReplicationActivityStatus replicationActivityStatus) {
        Preconditions.checkNotNull((Object)containerMapping);
        Preconditions.checkNotNull((Object)node2ContainerMap);
        Preconditions.checkNotNull((Object)replicationActivityStatus);
        this.containerStateManager = containerMapping.getStateManager();
        this.containerMapping = containerMapping;
        this.node2ContainerMap = node2ContainerMap;
        this.replicationStatus = replicationActivityStatus;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode, EventPublisher publisher) {
        DatanodeDetails datanodeOrigin = containerReportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)containerReportFromDatanode.getReport();
        try {
            this.containerMapping.processContainerReports(datanodeOrigin, containerReport, false);
            Set<ContainerID> containerIds = containerReport.getReportsList().stream().map(StorageContainerDatanodeProtocolProtos.ContainerInfo::getContainerID).map(ContainerID::new).collect(Collectors.toSet());
            ReportResult reportResult = this.node2ContainerMap.processReport(datanodeOrigin.getUuid(), containerIds);
            this.node2ContainerMap.setContainersForDatanode(datanodeOrigin.getUuid(), containerIds);
            for (ContainerID containerID : reportResult.getMissingEntries()) {
                this.containerStateManager.removeContainerReplica(containerID, datanodeOrigin);
                this.checkReplicationState(containerID, publisher);
            }
            for (ContainerID containerID : reportResult.getNewEntries()) {
                this.containerStateManager.addContainerReplica(containerID, datanodeOrigin);
                this.checkReplicationState(containerID, publisher);
            }
        }
        catch (IOException e) {
            LOG.error("Error on processing container report from datanode {}", (Object)datanodeOrigin, (Object)e);
        }
    }

    private void checkReplicationState(ContainerID containerID, EventPublisher publisher) throws SCMException {
        ContainerInfo container = this.containerStateManager.getContainer(containerID);
        if (container == null) {
            LOG.warn("Container is missing from containerStateManager. Can't request replication. {}", (Object)containerID);
            return;
        }
        if (container.isContainerOpen()) {
            return;
        }
        ReplicationRequest replicationState = this.containerStateManager.checkReplicationState(containerID);
        if (replicationState != null) {
            if (this.replicationStatus.isReplicationEnabled()) {
                publisher.fireEvent(SCMEvents.REPLICATE_CONTAINER, (Object)replicationState);
            } else {
                LOG.warn("Over/under replicated container but the replication is not (yet) enabled: " + replicationState.toString());
            }
        }
    }
}

