/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.Mapping;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventWatcher;
import org.apache.hadoop.hdds.server.events.IdentifiableEventPayload;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerWatcher
extends EventWatcher<CloseContainerEventHandler.CloseContainerRetryableReq, CommandStatusReportHandler.CloseContainerStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(CloseContainerWatcher.class);
    private final Mapping containerManager;

    public CloseContainerWatcher(Event<CloseContainerEventHandler.CloseContainerRetryableReq> startEvent, Event<CommandStatusReportHandler.CloseContainerStatus> completionEvent, LeaseManager<Long> leaseManager, Mapping containerManager) {
        super(startEvent, completionEvent, leaseManager);
        this.containerManager = containerManager;
    }

    protected void onTimeout(EventPublisher publisher, CloseContainerEventHandler.CloseContainerRetryableReq payload) {
        this.resendEventToHandler(payload.getId(), publisher);
    }

    protected void onFinished(EventPublisher publisher, CloseContainerEventHandler.CloseContainerRetryableReq payload) {
        LOG.trace("CloseContainerCommand for containerId: {} executed ", (Object)payload.getContainerID().getId());
    }

    protected synchronized void handleCompletion(CommandStatusReportHandler.CloseContainerStatus status, EventPublisher publisher) throws LeaseNotFoundException {
        if (status.getCmdStatus().getStatus().equals((Object)StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING)) {
            return;
        }
        CloseContainerEventHandler.CloseContainerRetryableReq closeCont = (CloseContainerEventHandler.CloseContainerRetryableReq)this.getTrackedEventbyId(status.getId());
        super.handleCompletion((IdentifiableEventPayload)status, publisher);
        if (status.getCmdStatus().getStatus().equals((Object)StorageContainerDatanodeProtocolProtos.CommandStatus.Status.FAILED) && closeCont != null) {
            this.resendEventToHandler(closeCont.getId(), publisher);
        }
    }

    private void resendEventToHandler(long containerID, EventPublisher publisher) {
        try {
            if (this.containerManager.getContainer(containerID).isContainerOpen()) {
                publisher.fireEvent(SCMEvents.CLOSE_CONTAINER, (Object)ContainerID.valueof((long)containerID));
            }
        }
        catch (IOException e) {
            LOG.warn("Error in CloseContainerWatcher while processing event for containerId {} ExceptionMsg: ", (Object)containerID, (Object)e.getMessage());
        }
    }
}

