/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.Mapping;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.IdentifiableEventPayload;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerEventHandler
implements EventHandler<ContainerID> {
    public static final Logger LOG = LoggerFactory.getLogger(CloseContainerEventHandler.class);
    private final Mapping containerManager;

    public CloseContainerEventHandler(Mapping containerManager) {
        this.containerManager = containerManager;
    }

    public void onMessage(ContainerID containerID, EventPublisher publisher) {
        ContainerInfo info;
        ContainerWithPipeline containerWithPipeline;
        LOG.info("Close container Event triggered for container : {}", (Object)containerID.getId());
        try {
            containerWithPipeline = this.containerManager.getContainerWithPipeline(containerID.getId());
            info = containerWithPipeline.getContainerInfo();
            if (info == null) {
                LOG.error("Failed to update the container state. Container with id : {} does not exist", (Object)containerID.getId());
                return;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to update the container state. Container with id : {} does not exist", (Object)containerID.getId(), (Object)e);
            return;
        }
        HddsProtos.LifeCycleState state = info.getState();
        try {
            switch (state) {
                case ALLOCATED: {
                    LOG.debug("Closing container {} in {} state", (Object)containerID, (Object)state);
                    this.containerManager.updateContainerState(containerID.getId(), HddsProtos.LifeCycleEvent.CREATE);
                    break;
                }
                case CREATING: {
                    LOG.debug("Closing container {} in {} state", (Object)containerID, (Object)state);
                    break;
                }
                case OPEN: {
                    this.containerManager.updateContainerState(containerID.getId(), HddsProtos.LifeCycleEvent.FINALIZE);
                    this.fireCloseContainerEvents(containerWithPipeline, info, publisher);
                    break;
                }
                case CLOSING: {
                    this.fireCloseContainerEvents(containerWithPipeline, info, publisher);
                    break;
                }
                case CLOSED: 
                case DELETING: 
                case DELETED: {
                    LOG.info("container with id : {} is in {} state and need not be closed.", (Object)containerID.getId(), (Object)info.getState());
                    break;
                }
                default: {
                    throw new IOException("Invalid container state for container " + containerID);
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to update the container state forcontainer : {}" + containerID, (Throwable)ex);
        }
    }

    private void fireCloseContainerEvents(ContainerWithPipeline containerWithPipeline, ContainerInfo info, EventPublisher publisher) {
        ContainerID containerID = info.containerID();
        CloseContainerCommand closeContainerCommand = new CloseContainerCommand(containerID.getId(), info.getReplicationType(), info.getPipelineID());
        Pipeline pipeline = containerWithPipeline.getPipeline();
        pipeline.getMachines().stream().map(datanode -> new CommandForDatanode(datanode.getUuid(), (SCMCommand)closeContainerCommand)).forEach(command -> publisher.fireEvent(SCMEvents.DATANODE_COMMAND, command));
        publisher.fireEvent(SCMEvents.CLOSE_CONTAINER_RETRYABLE_REQ, (Object)new CloseContainerRetryableReq(containerID));
        LOG.trace("Issuing {} on Pipeline {} for container", new Object[]{closeContainerCommand, pipeline, containerID});
    }

    public static class CloseContainerRetryableReq
    implements IdentifiableEventPayload {
        private ContainerID containerID;

        public CloseContainerRetryableReq(ContainerID containerID) {
            this.containerID = containerID;
        }

        public ContainerID getContainerID() {
            return this.containerID;
        }

        public long getId() {
            return this.containerID.getId();
        }
    }
}

