/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;

public class PendingDeleteStatusList {
    private List<PendingDeleteStatus> pendingDeleteStatuses;
    private DatanodeDetails datanodeDetails;

    public PendingDeleteStatusList(DatanodeDetails datanodeDetails) {
        this.datanodeDetails = datanodeDetails;
        this.pendingDeleteStatuses = new LinkedList<PendingDeleteStatus>();
    }

    public void addPendingDeleteStatus(long dnDeleteTransactionId, long scmDeleteTransactionId, long containerId) {
        this.pendingDeleteStatuses.add(new PendingDeleteStatus(dnDeleteTransactionId, scmDeleteTransactionId, containerId));
    }

    public List<PendingDeleteStatus> getPendingDeleteStatuses() {
        return this.pendingDeleteStatuses;
    }

    public int getNumPendingDeletes() {
        return this.pendingDeleteStatuses.size();
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public static class PendingDeleteStatus {
        private long dnDeleteTransactionId;
        private long scmDeleteTransactionId;
        private long containerId;

        public PendingDeleteStatus(long dnDeleteTransactionId, long scmDeleteTransactionId, long containerId) {
            this.dnDeleteTransactionId = dnDeleteTransactionId;
            this.scmDeleteTransactionId = scmDeleteTransactionId;
            this.containerId = containerId;
        }

        public long getDnDeleteTransactionId() {
            return this.dnDeleteTransactionId;
        }

        public long getScmDeleteTransactionId() {
            return this.scmDeleteTransactionId;
        }

        public long getContainerId() {
            return this.containerId;
        }
    }
}

