/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockmanagerMXBean;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.hdds.scm.container.Mapping;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.ChillModePrecheck;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements EventHandler<Boolean>,
BlockManager,
BlockmanagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private final NodeManager nodeManager;
    private final Mapping containerManager;
    private final long containerSize;
    private final DeletedBlockLog deletedBlockLog;
    private final SCMBlockDeletingService blockDeletingService;
    private final int containerProvisionBatchSize;
    private final Random rand;
    private ObjectName mxBean;
    private ChillModePrecheck chillModePrecheck;

    public BlockManagerImpl(Configuration conf, NodeManager nodeManager, Mapping containerManager, EventPublisher eventPublisher) throws IOException {
        this.nodeManager = nodeManager;
        this.containerManager = containerManager;
        this.containerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.containerProvisionBatchSize = conf.getInt("ozone.scm.container.provision_batch_size", 20);
        this.rand = new Random();
        this.mxBean = MBeans.register((String)"BlockManager", (String)"BlockManagerImpl", (Object)this);
        this.deletedBlockLog = new DeletedBlockLogImpl(conf, containerManager);
        long svcInterval = conf.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
        long serviceTimeout = conf.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new SCMBlockDeletingService(this.deletedBlockLog, containerManager, nodeManager, eventPublisher, svcInterval, serviceTimeout, conf);
        this.chillModePrecheck = new ChillModePrecheck();
    }

    @Override
    public void start() throws IOException {
        this.blockDeletingService.start();
    }

    @Override
    public void stop() throws IOException {
        this.blockDeletingService.shutdown();
        this.close();
    }

    private synchronized void preAllocateContainers(int count, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        for (int i = 0; i < count; ++i) {
            try {
                ContainerWithPipeline containerWithPipeline = this.containerManager.allocateContainer(type, factor, owner);
                if (containerWithPipeline != null) continue;
                LOG.warn("Unable to allocate container.");
                continue;
            }
            catch (IOException ex) {
                LOG.warn("Unable to allocate container: {}", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatedBlock allocateBlock(long size, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ContainerWithPipeline containerWithPipeline;
        BlockManagerImpl blockManagerImpl;
        LOG.trace("Size;{} , type : {}, factor : {} ", new Object[]{size, type, factor});
        ScmUtils.preCheck(HddsProtos.ScmOps.allocateBlock, this.chillModePrecheck);
        if (size < 0L || size > this.containerSize) {
            LOG.warn("Invalid block size requested : {}", (Object)size);
            throw new SCMException("Unsupported block size: " + size, SCMException.ResultCodes.INVALID_BLOCK_SIZE);
        }
        if (!this.containerManager.getStateManager().getContainerStateMap().getContainerIDsByState(HddsProtos.LifeCycleState.ALLOCATED).isEmpty()) {
            blockManagerImpl = this;
            synchronized (blockManagerImpl) {
                containerWithPipeline = this.containerManager.getMatchingContainerWithPipeline(size, owner, type, factor, HddsProtos.LifeCycleState.ALLOCATED);
                if (containerWithPipeline != null) {
                    this.containerManager.updateContainerState(containerWithPipeline.getContainerInfo().getContainerID(), HddsProtos.LifeCycleEvent.CREATE);
                    return this.newBlock(containerWithPipeline, HddsProtos.LifeCycleState.ALLOCATED);
                }
            }
        }
        if ((containerWithPipeline = this.containerManager.getMatchingContainerWithPipeline(size, owner, type, factor, HddsProtos.LifeCycleState.OPEN)) != null) {
            return this.newBlock(containerWithPipeline, HddsProtos.LifeCycleState.OPEN);
        }
        blockManagerImpl = this;
        synchronized (blockManagerImpl) {
            if (!this.containerManager.getStateManager().getContainerStateMap().getContainerIDsByState(HddsProtos.LifeCycleState.ALLOCATED).isEmpty()) {
                containerWithPipeline = this.containerManager.getMatchingContainerWithPipeline(size, owner, type, factor, HddsProtos.LifeCycleState.ALLOCATED);
            }
            if (containerWithPipeline == null) {
                this.preAllocateContainers(this.containerProvisionBatchSize, type, factor, owner);
                containerWithPipeline = this.containerManager.getMatchingContainerWithPipeline(size, owner, type, factor, HddsProtos.LifeCycleState.ALLOCATED);
            }
            if (containerWithPipeline != null) {
                this.containerManager.updateContainerState(containerWithPipeline.getContainerInfo().getContainerID(), HddsProtos.LifeCycleEvent.CREATE);
                return this.newBlock(containerWithPipeline, HddsProtos.LifeCycleState.ALLOCATED);
            }
        }
        LOG.error("Unable to allocate a block for the size: {}, type: {}, factor: {}", new Object[]{size, type, factor});
        return null;
    }

    private AllocatedBlock newBlock(ContainerWithPipeline containerWithPipeline, HddsProtos.LifeCycleState state) throws IOException {
        ContainerInfo containerInfo = containerWithPipeline.getContainerInfo();
        if (containerWithPipeline.getPipeline().getDatanodes().size() == 0) {
            LOG.error("Pipeline Machine count is zero.");
            return null;
        }
        long localID = UniqueId.next();
        long containerID = containerInfo.getContainerID();
        boolean createContainer = state == HddsProtos.LifeCycleState.ALLOCATED;
        AllocatedBlock.Builder abb = new AllocatedBlock.Builder().setBlockID(new BlockID(containerID, localID)).setPipeline(containerWithPipeline.getPipeline()).setShouldCreateContainer(createContainer);
        LOG.trace("New block allocated : {} Container ID: {}", (Object)localID, (Object)containerID);
        return abb.build();
    }

    @Override
    public void deleteBlocks(List<BlockID> blockIDs) throws IOException {
        if (!this.nodeManager.isOutOfChillMode()) {
            throw new SCMException("Unable to delete block while in chill mode", SCMException.ResultCodes.CHILL_MODE_EXCEPTION);
        }
        LOG.info("Deleting blocks {}", (Object)StringUtils.join((CharSequence)",", blockIDs));
        HashMap<Long, List<Long>> containerBlocks = new HashMap<Long, List<Long>>();
        for (BlockID block : blockIDs) {
            long containerID = block.getContainerID();
            if (containerBlocks.containsKey(containerID)) {
                ((List)containerBlocks.get(containerID)).add(block.getLocalID());
                continue;
            }
            ArrayList<Long> item = new ArrayList<Long>();
            item.add(block.getLocalID());
            containerBlocks.put(containerID, item);
        }
        try {
            this.deletedBlockLog.addTransactions(containerBlocks);
        }
        catch (IOException e) {
            throw new IOException("Skip writing the deleted blocks info to the delLog because addTransaction fails. Batch skipped: " + StringUtils.join((CharSequence)",", blockIDs), e);
        }
    }

    @Override
    public DeletedBlockLog getDeletedBlockLog() {
        return this.deletedBlockLog;
    }

    @Override
    public void close() throws IOException {
        if (this.deletedBlockLog != null) {
            this.deletedBlockLog.close();
        }
        this.blockDeletingService.shutdown();
        if (this.mxBean != null) {
            MBeans.unregister((ObjectName)this.mxBean);
            this.mxBean = null;
        }
    }

    @Override
    public int getOpenContainersNo() {
        return 0;
    }

    @Override
    public SCMBlockDeletingService getSCMBlockDeletingService() {
        return this.blockDeletingService;
    }

    public void onMessage(Boolean inChillMode, EventPublisher publisher) {
        this.chillModePrecheck.setInChillMode(inChillMode);
    }

    public boolean isScmInChillMode() {
        return this.chillModePrecheck.isInChillMode();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public static final class UniqueId {
        private static volatile short offset = 0;

        private UniqueId() {
        }

        public static synchronized long next() {
            long utcTime = Time.getUtcTime();
            if ((utcTime & 0xFFFF000000000000L) == 0L) {
                short s = offset;
                offset = (short)(s + 1);
                return utcTime << 16 | (long)(s & 0xFFFF);
            }
            throw new RuntimeException("Got invalid UTC time, cannot generate unique Id. UTC Time: " + utcTime);
        }
    }
}

