/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.utils;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;

@InterfaceAudience.Private
public final class OzoneUtils {
    public static final String ENCODING_NAME = "UTF-8";
    public static final Charset ENCODING = Charset.forName("UTF-8");
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    private OzoneUtils() {
    }

    public static void verifyMaxKeyLength(String length) throws IllegalArgumentException {
        int maxKey = 0;
        try {
            maxKey = Integer.parseInt(length);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid max key length, the vaule should be digital.");
        }
        if (maxKey <= 0) {
            throw new IllegalArgumentException("Invalid max key length, the vaule should be a positive number.");
        }
    }

    public static String getRequestID() {
        return UUID.randomUUID().toString();
    }

    public static String getHostName() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return host;
    }

    public static String getDatanodeIdFilePath(Configuration conf) {
        return HddsUtils.getDatanodeIdFilePath((Configuration)conf);
    }

    public static String formatTime(long millis) {
        return DATE_FORMAT.get().format(millis);
    }

    public static long formatDate(String date) throws ParseException {
        Preconditions.checkNotNull((Object)date, (Object)"Date string should not be null.");
        return DATE_FORMAT.get().parse(date).getTime();
    }

    public static boolean isOzoneEnabled(Configuration conf) {
        return HddsUtils.isHddsEnabled((Configuration)conf);
    }

    public static void verifyResourceName(String resName) throws IllegalArgumentException {
        if (resName == null) {
            throw new IllegalArgumentException("Bucket or Volume name is null");
        }
        if (resName.length() < 3 || resName.length() > 63) {
            throw new IllegalArgumentException("Bucket or Volume length is illegal, valid length is 3-63 characters");
        }
        if (resName.charAt(0) == '.' || resName.charAt(0) == '-') {
            throw new IllegalArgumentException("Bucket or Volume name cannot start with a period or dash");
        }
        if (resName.charAt(resName.length() - 1) == '.' || resName.charAt(resName.length() - 1) == '-') {
            throw new IllegalArgumentException("Bucket or Volume name cannot end with a period or dash");
        }
        boolean isIPv4 = true;
        int prev = 0;
        for (int index = 0; index < resName.length(); ++index) {
            char currChar = resName.charAt(index);
            if (currChar != '.') {
                boolean bl = isIPv4 = currChar >= '0' && currChar <= '9' && isIPv4;
            }
            if (currChar > 'A' && currChar < 'Z') {
                throw new IllegalArgumentException("Bucket or Volume name does not support uppercase characters");
            }
            if (currChar != '.' && currChar != '-' && (currChar < '0' || currChar > '9' && currChar < 'a' || currChar > 'z')) {
                throw new IllegalArgumentException("Bucket or Volume name has an unsupported character : " + currChar);
            }
            if (prev == 46 && currChar == '.') {
                throw new IllegalArgumentException("Bucket or Volume name should not have two contiguous periods");
            }
            if (prev == 45 && currChar == '.') {
                throw new IllegalArgumentException("Bucket or Volume name should not have period after dash");
            }
            if (prev == 46 && currChar == '-') {
                throw new IllegalArgumentException("Bucket or Volume name should not have dash after period");
            }
            prev = currChar;
        }
        if (isIPv4) {
            throw new IllegalArgumentException("Bucket or Volume name cannot be an IPv4 address or all numeric");
        }
    }
}

