/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.web.request.OzoneQuota;
import org.apache.hadoop.ozone.web.response.VolumeOwner;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

@InterfaceAudience.Private
public class VolumeInfo
implements Comparable<VolumeInfo> {
    static final String VOLUME_INFO = "VOLUME_INFO_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(VolumeInfo.class);
    private static final ObjectWriter WRITER;
    private VolumeOwner owner;
    private OzoneQuota quota;
    private String volumeName;
    private String createdOn;
    private String createdBy;
    private long bytesUsed;
    private long bucketCount;

    public VolumeInfo(String volumeName, String createdOn, String createdBy) {
        this.createdOn = createdOn;
        this.volumeName = volumeName;
        this.createdBy = createdBy;
    }

    public VolumeInfo() {
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public VolumeOwner getOwner() {
        return this.owner;
    }

    public void setOwner(VolumeOwner owner) {
        this.owner = owner;
    }

    public OzoneQuota getQuota() {
        return this.quota;
    }

    public void setQuota(OzoneQuota quota) {
        this.quota = quota;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    @Override
    public int compareTo(VolumeInfo o) {
        return this.volumeName.compareTo(o.getVolumeName());
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public void setBytesUsed(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public static VolumeInfo parse(String data) throws IOException {
        return (VolumeInfo)READER.readValue(data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeInfo otherInfo = (VolumeInfo)obj;
        return otherInfo.getVolumeName().equals(this.getVolumeName());
    }

    public int hashCode() {
        return this.getVolumeName().hashCode();
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public void setBucketCount(long bucketCount) {
        this.bucketCount = bucketCount;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"bytesUsed", "bucketCount"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(VOLUME_INFO, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="VOLUME_INFO_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

