/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.web.response.VolumeInfo;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

@InterfaceAudience.Private
public class ListVolumes {
    private List<VolumeInfo> volumes = new LinkedList<VolumeInfo>();
    static final String VOLUME_LIST = "VOLUME_LIST_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(ListVolumes.class);
    private static final ObjectWriter WRITER;

    public List<VolumeInfo> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<VolumeInfo> volumes) {
        this.volumes = volumes;
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    public static ListVolumes parse(String data) throws IOException {
        return (ListVolumes)READER.readValue(data);
    }

    public void addVolume(VolumeInfo info) {
        this.volumes.add(info);
    }

    public void sort() {
        Collections.sort(this.volumes);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"bytesUsed", "bucketCount"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(VOLUME_LIST, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="VOLUME_LIST_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

