/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

public class KeyInfo
implements Comparable<KeyInfo> {
    static final String OBJECT_INFO = "OBJECT_INFO_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(KeyInfo.class);
    private static final ObjectWriter WRITER;
    private long version;
    private String md5hash;
    private String createdOn;
    private String modifiedOn;
    private long size;
    private String keyName;
    private String dataFileName;

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getModifiedOn() {
        return this.modifiedOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public void setModifiedOn(String modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getMd5hash() {
        return this.md5hash;
    }

    public void setMd5hash(String md5hash) {
        this.md5hash = md5hash;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public int compareTo(KeyInfo o) {
        if (this.keyName.compareTo(o.getKeyName()) != 0) {
            return this.keyName.compareTo(o.getKeyName());
        }
        if (this.getVersion() == o.getVersion()) {
            return 0;
        }
        if (this.getVersion() < o.getVersion()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyInfo keyInfo = (KeyInfo)o;
        return new EqualsBuilder().append(this.version, keyInfo.version).append((Object)this.keyName, (Object)keyInfo.keyName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.version).append((Object)this.keyName).toHashCode();
    }

    public static KeyInfo parse(String jsonString) throws IOException {
        return (KeyInfo)READER.readValue(jsonString);
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"dataFileName"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(OBJECT_INFO, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="OBJECT_INFO_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

