/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

public class BucketInfo
implements Comparable<BucketInfo> {
    static final String BUCKET_INFO = "BUCKET_INFO_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(BucketInfo.class);
    private static final ObjectWriter WRITER;
    private String volumeName;
    private String bucketName;
    private String createdOn;
    private List<OzoneAcl> acls;
    private OzoneConsts.Versioning versioning;
    private StorageType storageType;
    private long bytesUsed;
    private long keyCount;

    public BucketInfo(String volumeName, String bucketName) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
    }

    public BucketInfo() {
        this.acls = new LinkedList<OzoneAcl>();
    }

    public static BucketInfo parse(String jsonString) throws IOException {
        return (BucketInfo)READER.readValue(jsonString);
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public void setAcls(List<OzoneAcl> acls) {
        this.acls = acls;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    public OzoneConsts.Versioning getVersioning() {
        return this.versioning;
    }

    public void setVersioning(OzoneConsts.Versioning versioning) {
        this.versioning = versioning;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCreatedOn(String creationTime) {
        this.createdOn = creationTime;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    @Override
    public int compareTo(BucketInfo o) {
        Preconditions.checkState((boolean)o.getVolumeName().equals(this.getVolumeName()));
        return this.bucketName.compareTo(o.getBucketName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketInfo)) {
            return false;
        }
        BucketInfo that = (BucketInfo)o;
        Preconditions.checkState((boolean)that.getVolumeName().equals(this.getVolumeName()));
        return this.bucketName.equals(that.bucketName);
    }

    public int hashCode() {
        return this.bucketName.hashCode();
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public void setBytesUsed(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public void setKeyCount(long keyCount) {
        this.keyCount = keyCount;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"bytesUsed", "keyCount"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(BUCKET_INFO, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="BUCKET_INFO_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

