/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class OzoneQuota {
    private Units unit;
    private int size;

    public int getSize() {
        return this.size;
    }

    public Units getUnit() {
        return this.unit;
    }

    public OzoneQuota() {
        this.size = 0;
        this.unit = Units.UNDEFINED;
    }

    public OzoneQuota(int size, Units unit) {
        this.size = size;
        this.unit = unit;
    }

    public static String formatQuota(OzoneQuota quota) {
        return String.valueOf(quota.size) + (Object)((Object)quota.unit);
    }

    public static OzoneQuota parseQuota(String quotaString) throws IllegalArgumentException {
        if (quotaString == null || quotaString.isEmpty()) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        if (OzoneQuota.isRemove(quotaString)) {
            throw new IllegalArgumentException("Remove is invalid in this context.");
        }
        String uppercase = quotaString.toUpperCase().replaceAll("\\s+", "");
        String size = "";
        Units currUnit = Units.MB;
        Boolean found = false;
        if (uppercase.endsWith("MB")) {
            size = uppercase.substring(0, uppercase.length() - "MB".length());
            currUnit = Units.MB;
            found = true;
        }
        if (uppercase.endsWith("GB")) {
            size = uppercase.substring(0, uppercase.length() - "GB".length());
            currUnit = Units.GB;
            found = true;
        }
        if (uppercase.endsWith("TB")) {
            size = uppercase.substring(0, uppercase.length() - "TB".length());
            currUnit = Units.TB;
            found = true;
        }
        if (uppercase.endsWith("BYTES")) {
            size = uppercase.substring(0, uppercase.length() - "BYTES".length());
            currUnit = Units.BYTES;
            found = true;
        }
        if (!found.booleanValue()) {
            throw new IllegalArgumentException("Quota unit not recognized. Supported values are BYTES, MB, GB and TB.");
        }
        int nSize = Integer.parseInt(size);
        if (nSize < 0) {
            throw new IllegalArgumentException("Quota cannot be negative.");
        }
        return new OzoneQuota(nSize, currUnit);
    }

    public static boolean isRemove(String quotaString) {
        return quotaString != null && quotaString.compareToIgnoreCase("remove") == 0;
    }

    @JsonIgnore
    public long sizeInBytes() {
        switch (this.unit) {
            case BYTES: {
                return this.getSize();
            }
            case MB: {
                return (long)this.getSize() * 0x100000L;
            }
            case GB: {
                return (long)this.getSize() * 0x40000000L;
            }
            case TB: {
                return (long)this.getSize() * 0x10000000000L;
            }
        }
        return -1L;
    }

    public static OzoneQuota getOzoneQuota(long sizeInBytes) {
        Units unit;
        long size;
        if (sizeInBytes % 0x10000000000L == 0L) {
            size = sizeInBytes / 0x10000000000L;
            unit = Units.TB;
        } else if (sizeInBytes % 0x40000000L == 0L) {
            size = sizeInBytes / 0x40000000L;
            unit = Units.GB;
        } else if (sizeInBytes % 0x100000L == 0L) {
            size = sizeInBytes / 0x100000L;
            unit = Units.MB;
        } else {
            size = sizeInBytes;
            unit = Units.BYTES;
        }
        return new OzoneQuota((int)size, unit);
    }

    public static enum Units {
        UNDEFINED,
        BYTES,
        MB,
        GB,
        TB;

    }
}

