/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.request.OzoneQuota;

@InterfaceAudience.Private
public class VolumeArgs
extends UserArgs {
    private String adminName;
    private final String volumeName;
    private OzoneQuota quota;

    public OzoneQuota getQuota() {
        return this.quota;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public VolumeArgs(String userName, String volumeName, String requestID, String hostName, Request request, UriInfo info, HttpHeaders headers, String[] groups) {
        super(userName, requestID, hostName, request, info, headers);
        super.setGroups(groups);
        this.volumeName = volumeName;
    }

    public VolumeArgs(String volumeName, UserArgs userArgs) {
        this(userArgs.getUserName(), volumeName, userArgs.getRequestID(), userArgs.getHostName(), userArgs.getRequest(), userArgs.getUri(), userArgs.getHeaders(), userArgs.getGroups());
    }

    public VolumeArgs(VolumeArgs volArgs) {
        this(volArgs.getVolumeName(), volArgs);
    }

    public void setQuota(String quota) throws IllegalArgumentException {
        this.quota = OzoneQuota.parseQuota(quota);
    }

    public void setQuota(OzoneQuota quota) {
        this.quota = quota;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    @Override
    public String getResourceName() {
        return super.getResourceName() + "/" + this.getVolumeName();
    }
}

