/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.util.Arrays;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class UserArgs {
    private String userName;
    private final String requestID;
    private final String hostName;
    private final UriInfo uri;
    private final Request request;
    private final HttpHeaders headers;
    private String[] groups;

    public UserArgs(String userName, String requestID, String hostName, Request req, UriInfo info, HttpHeaders httpHeaders) {
        this.hostName = hostName;
        this.userName = userName;
        this.requestID = requestID;
        this.uri = info;
        this.request = req;
        this.headers = httpHeaders;
    }

    public UserArgs(String requestID, String hostName, Request req, UriInfo info, HttpHeaders httpHeaders) {
        this.hostName = hostName;
        this.requestID = requestID;
        this.uri = info;
        this.request = req;
        this.headers = httpHeaders;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String[] getGroups() {
        return this.groups != null ? Arrays.copyOf(this.groups, this.groups.length) : null;
    }

    public void setGroups(String[] groups) {
        if (groups != null) {
            this.groups = Arrays.copyOf(groups, groups.length);
        }
    }

    public String getResourceName() {
        return this.getUserName();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Request getRequest() {
        return this.request;
    }

    public UriInfo getUri() {
        return this.uri;
    }
}

