/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.VolumeArgs;

public class BucketArgs
extends VolumeArgs {
    private final String bucketName;
    private List<OzoneAcl> addAcls;
    private List<OzoneAcl> removeAcls;
    private OzoneConsts.Versioning versioning;
    private StorageType storageType;

    public BucketArgs(String volumeName, String bucketName, UserArgs userArgs) {
        super(volumeName, userArgs);
        this.bucketName = bucketName;
        this.versioning = OzoneConsts.Versioning.NOT_DEFINED;
        this.storageType = null;
    }

    public BucketArgs(String bucketName, VolumeArgs volumeArgs) {
        super(volumeArgs);
        this.bucketName = bucketName;
        this.versioning = OzoneConsts.Versioning.NOT_DEFINED;
        this.storageType = null;
    }

    public BucketArgs(BucketArgs args) {
        this(args.getBucketName(), args);
        this.setAddAcls(args.getAddAcls());
        this.setRemoveAcls(args.getRemoveAcls());
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAddAcls() {
        return this.addAcls;
    }

    public void setAddAcls(List<OzoneAcl> acl) {
        this.addAcls = acl;
    }

    public List<OzoneAcl> getRemoveAcls() {
        return this.removeAcls;
    }

    public void addAcls(List<String> aclString) throws IllegalArgumentException {
        if (aclString == null) {
            throw new IllegalArgumentException("ACLs cannot be null");
        }
        if (this.addAcls == null) {
            this.addAcls = new LinkedList<OzoneAcl>();
        }
        for (String s : aclString) {
            this.addAcls.add(OzoneAcl.parseAcl((String)s));
        }
    }

    public void removeAcls(List<String> aclString) throws IllegalArgumentException {
        if (aclString == null) {
            throw new IllegalArgumentException("ACLs cannot be null");
        }
        if (this.removeAcls == null) {
            this.removeAcls = new LinkedList<OzoneAcl>();
        }
        for (String s : aclString) {
            this.removeAcls.add(OzoneAcl.parseAcl((String)s));
        }
    }

    public void setRemoveAcls(List<OzoneAcl> acl) {
        this.removeAcls = acl;
    }

    public OzoneConsts.Versioning getVersioning() {
        return this.versioning;
    }

    public void setVersioning(OzoneConsts.Versioning versioning) {
        this.versioning = versioning;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    @Override
    public String getResourceName() {
        return this.getVolumeName() + "/" + this.getBucketName();
    }

    public String getParentName() {
        return this.getUserName() + "/" + this.getVolumeName();
    }
}

