/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ThreadUtil;
import org.apache.hadoop.utils.HddsVersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OzoneVersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneVersionInfo.class);
    private Properties info = new Properties();
    private static OzoneVersionInfo OZONE_VERSION_INFO = new OzoneVersionInfo("ozone");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OzoneVersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = ThreadUtil.getResourceAsStream((ClassLoader)OzoneVersionInfo.class.getClassLoader(), (String)versionInfoFile);
            this.info.load(is);
        }
        catch (IOException ex) {
            try {
                LoggerFactory.getLogger(this.getClass()).warn("Could not read '" + versionInfoFile + "', " + ex.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(is);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)is);
        }
        IOUtils.closeStream((Closeable)is);
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    protected String _getRelease() {
        return this.info.getProperty("release", "Unknown");
    }

    protected String _getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    protected String _getBranch() {
        return this.info.getProperty("branch", "Unknown");
    }

    protected String _getDate() {
        return this.info.getProperty("date", "Unknown");
    }

    protected String _getUser() {
        return this.info.getProperty("user", "Unknown");
    }

    protected String _getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    protected String _getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    protected String _getBuildVersion() {
        return this._getVersion() + " from " + this._getRevision() + " by " + this._getUser() + " source checksum " + this._getSrcChecksum();
    }

    protected String _getProtocVersion() {
        return this.info.getProperty("protocVersion", "Unknown");
    }

    public static String getVersion() {
        return OZONE_VERSION_INFO._getVersion();
    }

    public static String getRelease() {
        return OZONE_VERSION_INFO._getRelease();
    }

    public static String getRevision() {
        return OZONE_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return OZONE_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return OZONE_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return OZONE_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return OZONE_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return OZONE_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return OZONE_VERSION_INFO._getBuildVersion();
    }

    public static String getProtocVersion() {
        return OZONE_VERSION_INFO._getProtocVersion();
    }

    public static void main(String[] args) {
        System.out.println("                  //////////////                 \n               ////////////////////              \n            ////////     ////////////////        \n           //////      ////////////////          \n          /////      ////////////////  /         \n         /////            ////////   ///         \n         ////           ////////    /////        \n        /////         ////////////////           \n        /////       ////////////////   //        \n         ////     ///////////////   /////        \n         /////  ///////////////     ////         \n          /////       //////      /////          \n           //////   //////       /////           \n             ///////////     ////////            \n               //////  ////////////              \n               ///   //////////                  \n              /    " + OzoneVersionInfo.getVersion() + "(" + OzoneVersionInfo.getRelease() + ")\n");
        System.out.println("Source code repository " + OzoneVersionInfo.getUrl() + " -r " + OzoneVersionInfo.getRevision());
        System.out.println("Compiled by " + OzoneVersionInfo.getUser() + " on " + OzoneVersionInfo.getDate());
        System.out.println("Compiled with protoc " + OzoneVersionInfo.getProtocVersion());
        System.out.println("From source with checksum " + OzoneVersionInfo.getSrcChecksum() + "\n");
        LOG.debug("This command was run using " + ClassUtil.findContainingJar(OzoneVersionInfo.class));
        HddsVersionInfo.main((String[])args);
    }
}

