/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.client.rest.response.BucketInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class ServiceInfo {
    private static final ObjectReader READER = new ObjectMapper().readerFor(ServiceInfo.class);
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private HddsProtos.NodeType nodeType;
    private String hostname;
    private Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> ports;

    public ServiceInfo() {
    }

    private ServiceInfo(HddsProtos.NodeType nodeType, String hostname, List<OzoneManagerProtocolProtos.ServicePort> portList) {
        Preconditions.checkNotNull((Object)nodeType);
        Preconditions.checkNotNull((Object)hostname);
        this.nodeType = nodeType;
        this.hostname = hostname;
        this.ports = new HashMap<OzoneManagerProtocolProtos.ServicePort.Type, Integer>();
        for (OzoneManagerProtocolProtos.ServicePort port : portList) {
            this.ports.put(port.getType(), port.getValue());
        }
    }

    public HddsProtos.NodeType getNodeType() {
        return this.nodeType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> getPorts() {
        return this.ports;
    }

    @JsonIgnore
    public int getPort(OzoneManagerProtocolProtos.ServicePort.Type type) {
        return this.ports.get((Object)type);
    }

    @JsonIgnore
    public OzoneManagerProtocolProtos.ServiceInfo getProtobuf() {
        OzoneManagerProtocolProtos.ServiceInfo.Builder builder = OzoneManagerProtocolProtos.ServiceInfo.newBuilder();
        builder.setNodeType(this.nodeType).setHostname(this.hostname).addAllServicePorts(this.ports.entrySet().stream().map(entry -> OzoneManagerProtocolProtos.ServicePort.newBuilder().setType((OzoneManagerProtocolProtos.ServicePort.Type)((Object)((Object)entry.getKey()))).setValue((Integer)entry.getValue()).build()).collect(Collectors.toList()));
        return builder.build();
    }

    @JsonIgnore
    public static ServiceInfo getFromProtobuf(OzoneManagerProtocolProtos.ServiceInfo serviceInfo) {
        return new ServiceInfo(serviceInfo.getNodeType(), serviceInfo.getHostname(), serviceInfo.getServicePortsList());
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public static BucketInfo parse(String jsonString) throws IOException {
        return (BucketInfo)READER.readValue(jsonString);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HddsProtos.NodeType node;
        private String host;
        private List<OzoneManagerProtocolProtos.ServicePort> portList = new ArrayList<OzoneManagerProtocolProtos.ServicePort>();

        public Builder setNodeType(HddsProtos.NodeType nodeType) {
            this.node = nodeType;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.host = hostname;
            return this;
        }

        public Builder addServicePort(OzoneManagerProtocolProtos.ServicePort servicePort) {
            this.portList.add(servicePort);
            return this;
        }

        public ServiceInfo build() {
            return new ServiceInfo(this.node, this.host, this.portList);
        }
    }
}

