/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmOzoneAclMap {
    private ArrayList<Map<String, OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights>> aclMaps = new ArrayList();

    OmOzoneAclMap() {
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            this.aclMaps.add(aclType.ordinal(), new HashMap());
        }
    }

    private Map<String, OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights> getMap(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type) {
        return this.aclMaps.get(type.ordinal());
    }

    private OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights getAcl(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type, String user) {
        return this.getMap(type).get(user);
    }

    public void addAcl(OzoneManagerProtocolProtos.OzoneAclInfo acl) {
        this.getMap(acl.getType()).put(acl.getName(), acl.getRights());
    }

    public boolean hasAccess(OzoneManagerProtocolProtos.OzoneAclInfo acl) {
        OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights storedRights = this.getAcl(acl.getType(), acl.getName());
        if (storedRights != null) {
            switch (acl.getRights()) {
                case READ: {
                    return storedRights == OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights.READ || storedRights == OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights.READ_WRITE;
                }
                case WRITE: {
                    return storedRights == OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights.WRITE || storedRights == OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights.READ_WRITE;
                }
                case READ_WRITE: {
                    return storedRights == OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights.READ_WRITE;
                }
            }
            return false;
        }
        return false;
    }

    public List<OzoneManagerProtocolProtos.OzoneAclInfo> ozoneAclGetProtobuf() {
        LinkedList<OzoneManagerProtocolProtos.OzoneAclInfo> aclList = new LinkedList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            for (Map.Entry<String, OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclRights> entry : this.aclMaps.get(type.ordinal()).entrySet()) {
                OzoneManagerProtocolProtos.OzoneAclInfo aclInfo = OzoneManagerProtocolProtos.OzoneAclInfo.newBuilder().setName(entry.getKey()).setType(type).setRights(entry.getValue()).build();
                aclList.add(aclInfo);
            }
        }
        return aclList;
    }

    public static OmOzoneAclMap ozoneAclGetFromProtobuf(List<OzoneManagerProtocolProtos.OzoneAclInfo> aclList) {
        OmOzoneAclMap aclMap = new OmOzoneAclMap();
        for (OzoneManagerProtocolProtos.OzoneAclInfo acl : aclList) {
            aclMap.addAcl(acl);
        }
        return aclMap;
    }
}

