/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmKeyLocationInfo {
    private final BlockID blockID;
    private final boolean shouldCreateContainer;
    private long length;
    private final long offset;
    private long createVersion;

    private OmKeyLocationInfo(BlockID blockID, boolean shouldCreateContainer, long length, long offset) {
        this.blockID = blockID;
        this.shouldCreateContainer = shouldCreateContainer;
        this.length = length;
        this.offset = offset;
    }

    public void setCreateVersion(long version) {
        this.createVersion = version;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public long getContainerID() {
        return this.blockID.getContainerID();
    }

    public long getLocalID() {
        return this.blockID.getLocalID();
    }

    public boolean getShouldCreateContainer() {
        return this.shouldCreateContainer;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public OzoneManagerProtocolProtos.KeyLocation getProtobuf() {
        return OzoneManagerProtocolProtos.KeyLocation.newBuilder().setBlockID(this.blockID.getProtobuf()).setShouldCreateContainer(this.shouldCreateContainer).setLength(this.length).setOffset(this.offset).setCreateVersion(this.createVersion).build();
    }

    public static OmKeyLocationInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyLocation keyLocation) {
        OmKeyLocationInfo info = new OmKeyLocationInfo(BlockID.getFromProtobuf((HddsProtos.BlockID)keyLocation.getBlockID()), keyLocation.getShouldCreateContainer(), keyLocation.getLength(), keyLocation.getOffset());
        info.setCreateVersion(keyLocation.getCreateVersion());
        return info;
    }

    public String toString() {
        return "{blockID={containerID=" + this.blockID.getContainerID() + ", localID=" + this.blockID.getLocalID() + "}, shouldCreateContainer=" + this.shouldCreateContainer + ", length=" + this.length + ", offset=" + this.offset + ", createVersion=" + this.createVersion + '}';
    }

    public static class Builder {
        private BlockID blockID;
        private boolean shouldCreateContainer;
        private long length;
        private long offset;

        public Builder setBlockID(BlockID blockId) {
            this.blockID = blockId;
            return this;
        }

        public Builder setShouldCreateContainer(boolean create) {
            this.shouldCreateContainer = create;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setOffset(long off) {
            this.offset = off;
            return this;
        }

        public OmKeyLocationInfo build() {
            return new OmKeyLocationInfo(this.blockID, this.shouldCreateContainer, this.length, this.offset);
        }
    }
}

