/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public final class OmBucketInfo
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private List<OzoneAcl> acls;
    private Boolean isVersionEnabled;
    private StorageType storageType;
    private final long creationTime;

    private OmBucketInfo(String volumeName, String bucketName, List<OzoneAcl> acls, boolean isVersionEnabled, StorageType storageType, long creationTime) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.acls = acls;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
        this.creationTime = creationTime;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("acls", this.acls != null ? this.acls.toString() : null);
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        auditMap.put("storageType", this.storageType != null ? this.storageType.name() : null);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        return auditMap;
    }

    public OzoneManagerProtocolProtos.BucketInfo getProtobuf() {
        return OzoneManagerProtocolProtos.BucketInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).addAllAcls(this.acls.stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList())).setIsVersionEnabled(this.isVersionEnabled).setStorageType(PBHelperClient.convertStorageType((StorageType)this.storageType)).setCreationTime(this.creationTime).build();
    }

    public static OmBucketInfo getFromProtobuf(OzoneManagerProtocolProtos.BucketInfo bucketInfo) {
        return new OmBucketInfo(bucketInfo.getVolumeName(), bucketInfo.getBucketName(), bucketInfo.getAclsList().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()), bucketInfo.getIsVersionEnabled(), PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)bucketInfo.getStorageType()), bucketInfo.getCreationTime());
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private List<OzoneAcl> acls = new LinkedList<OzoneAcl>();
        private Boolean isVersionEnabled = false;
        private StorageType storageType = StorageType.DISK;
        private long creationTime;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public OmBucketInfo build() {
            Preconditions.checkNotNull((Object)this.volumeName);
            Preconditions.checkNotNull((Object)this.bucketName);
            Preconditions.checkNotNull(this.acls);
            Preconditions.checkNotNull((Object)this.isVersionEnabled);
            Preconditions.checkNotNull((Object)this.storageType);
            return new OmBucketInfo(this.volumeName, this.bucketName, this.acls, this.isVersionEnabled, this.storageType, this.creationTime);
        }
    }
}

