/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public final class OmBucketArgs
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private List<OzoneAcl> addAcls;
    private List<OzoneAcl> removeAcls;
    private Boolean isVersionEnabled;
    private StorageType storageType;

    private OmBucketArgs(String volumeName, String bucketName, List<OzoneAcl> addAcls, List<OzoneAcl> removeAcls, Boolean isVersionEnabled, StorageType storageType) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.addAcls = addAcls;
        this.removeAcls = removeAcls;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAddAcls() {
        return this.addAcls;
    }

    public List<OzoneAcl> getRemoveAcls() {
        return this.removeAcls;
    }

    public Boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        if (this.addAcls != null) {
            auditMap.put("addAcls", this.addAcls.toString());
        }
        if (this.removeAcls != null) {
            auditMap.put("removeAcls", this.removeAcls.toString());
        }
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        if (this.storageType != null) {
            auditMap.put("storageType", this.storageType.name());
        }
        return auditMap;
    }

    public OzoneManagerProtocolProtos.BucketArgs getProtobuf() {
        OzoneManagerProtocolProtos.BucketArgs.Builder builder = OzoneManagerProtocolProtos.BucketArgs.newBuilder();
        builder.setVolumeName(this.volumeName).setBucketName(this.bucketName);
        if (this.addAcls != null && !this.addAcls.isEmpty()) {
            builder.addAllAddAcls(this.addAcls.stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()));
        }
        if (this.removeAcls != null && !this.removeAcls.isEmpty()) {
            builder.addAllRemoveAcls(this.removeAcls.stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()));
        }
        if (this.isVersionEnabled != null) {
            builder.setIsVersionEnabled(this.isVersionEnabled);
        }
        if (this.storageType != null) {
            builder.setStorageType(PBHelperClient.convertStorageType((StorageType)this.storageType));
        }
        return builder.build();
    }

    public static OmBucketArgs getFromProtobuf(OzoneManagerProtocolProtos.BucketArgs bucketArgs) {
        return new OmBucketArgs(bucketArgs.getVolumeName(), bucketArgs.getBucketName(), bucketArgs.getAddAclsList().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()), bucketArgs.getRemoveAclsList().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()), bucketArgs.hasIsVersionEnabled() ? Boolean.valueOf(bucketArgs.getIsVersionEnabled()) : null, bucketArgs.hasStorageType() ? PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)bucketArgs.getStorageType()) : null);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private List<OzoneAcl> addAcls;
        private List<OzoneAcl> removeAcls;
        private Boolean isVersionEnabled;
        private StorageType storageType;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setAddAcls(List<OzoneAcl> acls) {
            this.addAcls = acls;
            return this;
        }

        public Builder setRemoveAcls(List<OzoneAcl> acls) {
            this.removeAcls = acls;
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public OmBucketArgs build() {
            Preconditions.checkNotNull((Object)this.volumeName);
            Preconditions.checkNotNull((Object)this.bucketName);
            return new OmBucketArgs(this.volumeName, this.bucketName, this.addAcls, this.removeAcls, this.isVersionEnabled, this.storageType);
        }
    }
}

