/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipartUploader {
    public static final Logger LOG = LoggerFactory.getLogger(MultipartUploader.class);

    public abstract UploadHandle initialize(Path var1) throws IOException;

    public abstract PartHandle putPart(Path var1, InputStream var2, int var3, UploadHandle var4, long var5) throws IOException;

    public abstract PathHandle complete(Path var1, List<Pair<Integer, PartHandle>> var2, UploadHandle var3) throws IOException;

    public abstract void abort(Path var1, UploadHandle var2) throws IOException;

    protected void checkUploadId(byte[] uploadId) throws IllegalArgumentException {
        Preconditions.checkArgument((uploadId.length > 0 ? 1 : 0) != 0, (Object)"Empty UploadId is not valid");
    }
}

