/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.CheckedFunction;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerProxyMap<PROXY extends Closeable>
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(PeerProxyMap.class);
    private final String name;
    private final Map<RaftPeerId, PeerAndProxy> peers = new ConcurrentHashMap<RaftPeerId, PeerAndProxy>();
    private final Object resetLock = new Object();
    private final CheckedFunction<RaftPeer, PROXY, IOException> createProxy;

    public PeerProxyMap(String name, CheckedFunction<RaftPeer, PROXY, IOException> createProxy) {
        this.name = name;
        this.createProxy = createProxy;
    }

    public PeerProxyMap(String name) {
        this.name = name;
        this.createProxy = this::createProxyImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROXY getProxy(RaftPeerId id) throws IOException {
        PeerAndProxy p = this.peers.get(id);
        if (p == null) {
            Object object = this.resetLock;
            synchronized (object) {
                p = Objects.requireNonNull(this.peers.get(id), () -> this.name + ": Server " + id + " not found: peers=" + this.peers.keySet());
            }
        }
        return p.getProxy();
    }

    public void addPeers(Iterable<RaftPeer> newPeers) {
        for (RaftPeer p : newPeers) {
            this.computeIfAbsent(p);
        }
    }

    public void computeIfAbsent(RaftPeer p) {
        this.peers.computeIfAbsent(p.getId(), k -> new PeerAndProxy(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProxy(RaftPeerId id) {
        LOG.debug("{}: reset proxy for {}", (Object)this.name, (Object)id);
        Object object = this.resetLock;
        synchronized (object) {
            PeerAndProxy pp = this.peers.remove(id);
            RaftPeer peer = pp.getPeer();
            pp.close();
            this.computeIfAbsent(peer);
        }
    }

    public void handleException(RaftPeerId serverId, Exception e, boolean reconnect) {
        if (reconnect || IOUtils.shouldReconnect(e)) {
            this.resetProxy(serverId);
        }
    }

    public PROXY createProxyImpl(RaftPeer peer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.peers.values().forEach(PeerAndProxy::close);
    }

    private class PeerAndProxy
    implements Closeable {
        private final RaftPeer peer;
        private volatile PROXY proxy = null;
        private final LifeCycle lifeCycle;

        PeerAndProxy(RaftPeer peer) {
            this.peer = peer;
            this.lifeCycle = new LifeCycle(peer);
        }

        RaftPeer getPeer() {
            return this.peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PROXY getProxy() throws IOException {
            if (this.proxy == null) {
                PeerAndProxy peerAndProxy = this;
                synchronized (peerAndProxy) {
                    if (this.proxy == null) {
                        this.lifeCycle.startAndTransition(() -> {
                            this.proxy = (Closeable)PeerProxyMap.this.createProxy.apply(this.peer);
                        }, IOException.class);
                    }
                }
            }
            return this.proxy;
        }

        @Override
        public synchronized void close() {
            this.lifeCycle.checkStateAndClose(() -> {
                if (this.proxy != null) {
                    try {
                        this.proxy.close();
                    }
                    catch (IOException e) {
                        LOG.warn("{}: Failed to close proxy for peer {}, proxy class: ", new Object[]{PeerProxyMap.this.name, this.peer, this.proxy.getClass()});
                    }
                }
            });
        }
    }
}

