/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.ratis.util.CheckedRunnable;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycle {
    public static final Logger LOG = LoggerFactory.getLogger(LifeCycle.class);
    private volatile String name;
    private final AtomicReference<State> current = new AtomicReference<State>(State.NEW);

    public LifeCycle(Object name) {
        this.name = name.toString();
        LOG.debug("{}: {}", name, this.current);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void transition(State to) {
        State from = this.current.getAndSet(to);
        State.validate(this.name, from, to);
    }

    public boolean compareAndTransition(State from, State to) {
        if (this.current.compareAndSet(from, to)) {
            State.validate(this.name, from, to);
            return true;
        }
        return false;
    }

    public State getCurrentState() {
        return this.current.get();
    }

    public void assertCurrentState(State ... expected) {
        this.assertCurrentState((String n, State c) -> new IllegalStateException("STATE MISMATCHED: In " + n + ", current state " + (Object)c + " is not one of the expected states " + Arrays.toString((Object[])expected)), expected);
    }

    public <T extends Throwable> State assertCurrentState(BiFunction<String, State, T> newThrowable, State ... expected) throws T {
        State c = this.getCurrentState();
        if (!c.isOneOf(expected)) {
            throw (Throwable)newThrowable.apply(this.name, c);
        }
        return c;
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.getCurrentState());
    }

    @SafeVarargs
    public final <T extends Throwable> void startAndTransition(CheckedRunnable<T> startImpl, Class<? extends Throwable> ... exceptionClasses) throws T {
        this.transition(State.STARTING);
        try {
            startImpl.run();
            this.transition(State.RUNNING);
        }
        catch (Throwable t) {
            this.transition(ReflectionUtils.isInstance(t, exceptionClasses) ? State.NEW : State.EXCEPTION);
            throw t;
        }
    }

    public <T extends Throwable> void checkStateAndClose(CheckedRunnable<T> closeImpl) throws T {
        State c;
        if (this.compareAndTransition(State.NEW, State.CLOSED)) {
            return;
        }
        do {
            c = this.getCurrentState();
            if (!c.isOneOf(State.CLOSING, State.CLOSED)) continue;
            return;
        } while (!this.compareAndTransition(c, State.CLOSING));
        try {
            closeImpl.run();
        }
        finally {
            this.transition(State.CLOSED);
        }
    }

    public static enum State {
        NEW,
        STARTING,
        RUNNING,
        PAUSING,
        PAUSED,
        EXCEPTION,
        CLOSING,
        CLOSED;

        private static final Map<State, List<State>> PREDECESSORS;

        public boolean isOneOf(State ... states) {
            for (State e : states) {
                if (e != this) continue;
                return true;
            }
            return false;
        }

        static void put(State key, Map<State, List<State>> map, State ... values) {
            map.put(key, Collections.unmodifiableList(Arrays.asList(values)));
        }

        static boolean isValid(State from, State to) {
            return PREDECESSORS.get((Object)to).contains((Object)from);
        }

        static void validate(Object name, State from, State to) {
            LOG.debug("{}: {} -> {}", new Object[]{name, from, to});
            if (LOG.isTraceEnabled()) {
                LOG.trace("TRACE", new Throwable());
            }
            Preconditions.assertTrue(State.isValid(from, to), "ILLEGAL TRANSITION: In %s, %s -> %s", new Object[]{name, from, to});
        }

        static {
            EnumMap<State, List<State>> predecessors = new EnumMap<State, List<State>>(State.class);
            State.put(NEW, predecessors, STARTING);
            State.put(STARTING, predecessors, NEW, PAUSED);
            State.put(RUNNING, predecessors, STARTING);
            State.put(PAUSING, predecessors, RUNNING);
            State.put(PAUSED, predecessors, PAUSING);
            State.put(EXCEPTION, predecessors, STARTING, PAUSING, RUNNING);
            State.put(CLOSING, predecessors, STARTING, RUNNING, PAUSING, PAUSED, EXCEPTION);
            State.put(CLOSED, predecessors, NEW, CLOSING);
            PREDECESSORS = Collections.unmodifiableMap(predecessors);
        }
    }
}

