/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.slf4j.Logger;

public class ExitUtils {
    private static volatile boolean systemExitDisabled = false;
    private static volatile ExitException firstExitException;

    public static ExitException getFirstExitException() {
        return firstExitException;
    }

    public static void resetFirstExitException() {
        firstExitException = null;
    }

    public static boolean isTerminated() {
        return firstExitException != null;
    }

    public static void assertNotTerminated() {
        if (ExitUtils.isTerminated()) {
            throw new AssertionError("Unexpected exited.", ExitUtils.getFirstExitException());
        }
    }

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static void terminate(int status, String message, Throwable throwable, Logger log) throws ExitException {
        if (log != null) {
            String s = "Terminating with exit status " + status + ": " + message;
            if (status == 0) {
                log.info(s, throwable);
            } else {
                log.error(s, throwable);
            }
        }
        if (!systemExitDisabled) {
            System.exit(status);
        }
        ExitException ee = new ExitException(status, message, throwable);
        if (firstExitException == null) {
            firstExitException = ee;
        }
        throw ee;
    }

    public static void terminate(int status, String message, Logger log) {
        ExitUtils.terminate(status, message, null, log);
    }

    public static class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String message, Throwable throwable) {
            super(message, throwable);
            this.status = status;
        }
    }
}

