/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public class RetryPolicies {
    public static final RetryPolicy RETRY_FOREVER = new RetryForever();

    public static final RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, TimeDuration sleepTime) {
        return new RetryUpToMaximumCountWithFixedSleep(maxRetries, sleepTime);
    }

    static class RetryUpToMaximumCountWithFixedSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithFixedSleep(int maxRetries, TimeDuration sleepTime) {
            super(maxRetries, sleepTime);
        }
    }

    static abstract class RetryLimited
    implements RetryPolicy {
        private final int maxRetries;
        private final TimeDuration sleepTime;
        private String myString;

        RetryLimited(int maxRetries, TimeDuration sleepTime) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime.getDuration() + " < 0");
            }
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime() {
            return this.sleepTime;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public boolean shouldRetry(int retryCount) {
            return retryCount < this.maxRetries;
        }

        protected String getReason() {
            return RetryLimited.constructReasonString(this.maxRetries);
        }

        @VisibleForTesting
        public static String constructReasonString(int retries) {
            return "retries get failed due to exceeded maximum allowed retries number: " + retries;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxRetries=" + this.maxRetries + ", sleepTime=" + this.sleepTime + ")";
            }
            return this.myString;
        }
    }

    static class RetryForever
    implements RetryPolicy {
        RetryForever() {
        }

        @Override
        public boolean shouldRetry(int retryCount) {
            return true;
        }

        @Override
        public TimeDuration getSleepTime() {
            return TimeDuration.valueOf(0L, TimeUnit.MILLISECONDS);
        }
    }
}

