/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.NetUtils;

public class RaftPeer {
    private static final RaftPeer[] EMPTY_ARRAY = new RaftPeer[0];
    private final RaftPeerId id;
    private final String address;

    public static RaftPeer[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public RaftPeer(RaftPeerId id) {
        this(id, (String)null);
    }

    public RaftPeer(RaftPeerId id, InetSocketAddress address) {
        this(id, address == null ? null : NetUtils.address2String(address));
    }

    public RaftPeer(RaftPeerId id, String address) {
        this.id = Objects.requireNonNull(id, "id == null");
        this.address = address;
    }

    public RaftPeerId getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public String toString() {
        return this.id + ":" + this.address;
    }

    public boolean equals(Object o) {
        return o instanceof RaftPeer && this.id.equals(((RaftPeer)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

