/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.netty;

import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectStoreJerseyContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStoreJerseyContainer.class);
    private final WebApplication webapp;
    private StorageHandler storageHandler;

    public ObjectStoreJerseyContainer(WebApplication webapp) {
        this.webapp = webapp;
    }

    public void setStorageHandler(StorageHandler newStorageHandler) {
        this.storageHandler = newStorageHandler;
    }

    public Future<HttpResponse> dispatch(HttpRequest nettyReq, InputStream reqIn, OutputStream respOut) {
        final CountDownLatch latch = new CountDownLatch(1);
        final RequestRunner runner = new RequestRunner(nettyReq, reqIn, respOut, latch);
        final Thread thread = new Thread(runner);
        thread.setDaemon(true);
        thread.start();
        return new Future<HttpResponse>(){
            private volatile boolean isCancelled = false;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (latch.getCount() == 0L) {
                    return false;
                }
                if (!mayInterruptIfRunning) {
                    return false;
                }
                if (!thread.isAlive()) {
                    return false;
                }
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupted while attempting to cancel dispatch thread.");
                    Thread.currentThread().interrupt();
                    return false;
                }
                this.isCancelled = true;
                return true;
            }

            @Override
            public HttpResponse get() throws InterruptedException, ExecutionException {
                this.checkCancelled();
                latch.await();
                return this.getOrThrow();
            }

            @Override
            public HttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.checkCancelled();
                if (!latch.await(timeout, unit)) {
                    throw new TimeoutException(String.format("Timed out waiting for HttpResponse after %d %s.", timeout, unit.toString().toLowerCase()));
                }
                return this.getOrThrow();
            }

            @Override
            public boolean isCancelled() {
                return this.isCancelled;
            }

            @Override
            public boolean isDone() {
                return !this.isCancelled && latch.getCount() == 0L;
            }

            private void checkCancelled() {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
            }

            private HttpResponse getOrThrow() throws ExecutionException {
                try {
                    return runner.getResponse();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    private static HttpResponse jerseyResponseToNettyResponse(ContainerResponse jerseyResp) {
        DefaultHttpResponse nettyResp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)jerseyResp.getStatus()));
        for (Map.Entry header : jerseyResp.getHttpHeaders().entrySet()) {
            if (((String)header.getKey()).equalsIgnoreCase("Content-Length".toString()) || ((String)header.getKey()).equalsIgnoreCase("Transfer-Encoding".toString())) continue;
            nettyResp.headers().set((String)header.getKey(), (Iterable)header.getValue());
        }
        return nettyResp;
    }

    private static ContainerRequest nettyRequestToJerseyRequest(WebApplication webapp, HttpRequest nettyReq, InputStream reqIn) throws URISyntaxException {
        HttpHeaders nettyHeaders = nettyReq.headers();
        InBoundHeaders jerseyHeaders = new InBoundHeaders();
        for (String name : nettyHeaders.names()) {
            jerseyHeaders.put((Object)name, (Object)nettyHeaders.getAll(name));
        }
        String host = nettyHeaders.get("Host");
        String scheme = host.startsWith("https") ? "https://" : "http://";
        String baseUri = scheme + host + "/";
        String reqUri = scheme + host + nettyReq.getUri();
        LOG.trace("baseUri = {}, reqUri = {}", (Object)baseUri, (Object)reqUri);
        return new ContainerRequest(webapp, nettyReq.getMethod().name(), new URI(baseUri), new URI(reqUri), jerseyHeaders, reqIn);
    }

    private final class RequestRunner
    implements Runnable,
    ContainerResponseWriter {
        private final CountDownLatch latch;
        private final HttpRequest nettyReq;
        private final InputStream reqIn;
        private final OutputStream respOut;
        private Exception exception;
        private HttpResponse nettyResp;

        RequestRunner(HttpRequest nettyReq, InputStream reqIn, OutputStream respOut, CountDownLatch latch) {
            this.latch = latch;
            this.nettyReq = nettyReq;
            this.reqIn = reqIn;
            this.respOut = respOut;
        }

        @Override
        public void run() {
            LOG.trace("begin RequestRunner, nettyReq = {}", (Object)this.nettyReq);
            StorageHandlerBuilder.setStorageHandler(ObjectStoreJerseyContainer.this.storageHandler);
            try {
                ContainerRequest jerseyReq = ObjectStoreJerseyContainer.nettyRequestToJerseyRequest(ObjectStoreJerseyContainer.this.webapp, this.nettyReq, this.reqIn);
                ObjectStoreJerseyContainer.this.webapp.handleRequest(jerseyReq, (ContainerResponseWriter)this);
            }
            catch (Exception e) {
                try {
                    LOG.error("Error running Jersey Request Runner", (Throwable)e);
                    this.exception = e;
                    this.latch.countDown();
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqIn, this.respOut});
                    StorageHandlerBuilder.removeStorageHandler();
                    throw throwable;
                }
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqIn, this.respOut});
                StorageHandlerBuilder.removeStorageHandler();
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqIn, this.respOut});
            StorageHandlerBuilder.removeStorageHandler();
            LOG.trace("end RequestRunner, nettyReq = {}", (Object)this.nettyReq);
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse jerseyResp) {
            LOG.trace("begin writeStatusAndHeaders, contentLength = {}, jerseyResp = {}.", (Object)contentLength, (Object)jerseyResp);
            this.nettyResp = ObjectStoreJerseyContainer.jerseyResponseToNettyResponse(jerseyResp);
            this.nettyResp.headers().set("Content-Length", (Object)Math.max(0L, contentLength));
            this.nettyResp.headers().set("Connection", (Object)(HttpHeaders.isKeepAlive((HttpMessage)this.nettyReq) ? "keep-alive" : "close"));
            this.latch.countDown();
            LOG.trace("end writeStatusAndHeaders, contentLength = {}, jerseyResp = {}.", (Object)contentLength, (Object)jerseyResp);
            return this.respOut;
        }

        public void finish() throws IOException {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.respOut});
        }

        public HttpResponse getResponse() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.nettyResp;
        }
    }
}

