/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.netty;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ObjectStoreChannelHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(ObjectStoreChannelHandler.class);

    ObjectStoreChannelHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Unexpected exception in Netty pipeline.", cause);
        if (ctx.channel().isActive()) {
            ObjectStoreChannelHandler.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected static void sendErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse nettyResp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        nettyResp.headers().set("Content-Length", (Object)0);
        nettyResp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush((Object)nettyResp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

