/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.interfaces;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.ozone.client.rest.OzoneException;

@Path(value="/{volume}/{bucket}/{keys:.*}")
@Api(tags={"key"})
public interface Keys {
    @PUT
    @Consumes(value={"*/*"})
    @ApiOperation(value="Adds a key to an existing bucket.", notes="If the object already exists this call will overwrite or add with new version number if the bucket versioning is turned on.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response putKey(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @PathParam(value="keys") String var3, InputStream var4, @Context Request var5, @Context UriInfo var6, @Context HttpHeaders var7) throws OzoneException;

    @GET
    @ApiOperation(value="Gets the Key if it exists.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response getKey(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @PathParam(value="keys") String var3, @QueryParam(value="info") String var4, @Context Request var5, @Context UriInfo var6, @Context HttpHeaders var7) throws OzoneException;

    @DELETE
    @ApiOperation(value="Deletes an existing key")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response deleteKey(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @PathParam(value="keys") String var3, @Context Request var4, @Context UriInfo var5, @Context HttpHeaders var6) throws OzoneException;

    @POST
    @ApiOperation(value="Renames an existing key within a bucket")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response renameKey(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @PathParam(value="keys") String var3, @QueryParam(value="toKey") String var4, @Context Request var5, @Context UriInfo var6, @Context HttpHeaders var7) throws OzoneException;
}

