/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.interfaces;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.ozone.client.rest.OzoneException;

@Path(value="/{volume}/{bucket}")
@Api(tags={"bucket"})
public interface Bucket {
    @POST
    @ApiOperation(value="Create new bucket to a volume")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response createBucket(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @Context Request var3, @Context UriInfo var4, @Context HttpHeaders var5) throws OzoneException;

    @PUT
    @ApiOperation(value="Update bucket")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response updateBucket(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @Context Request var3, @Context UriInfo var4, @Context HttpHeaders var5) throws OzoneException;

    @DELETE
    @ApiOperation(value="Deletes an empty bucket.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response deleteBucket(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @Context Request var3, @Context UriInfo var4, @Context HttpHeaders var5) throws OzoneException;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List contents of a bucket")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response listBucket(@PathParam(value="volume") String var1, @PathParam(value="bucket") String var2, @DefaultValue(value="key") @QueryParam(value="info") String var3, @QueryParam(value="prefix") String var4, @DefaultValue(value="1000") @QueryParam(value="max-keys") int var5, @QueryParam(value="prev-key") String var6, @Context Request var7, @Context UriInfo var8, @Context HttpHeaders var9) throws OzoneException;
}

