/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.ozone.web.userauth.Simple;

@InterfaceAudience.Private
public final class UserHandlerBuilder {
    private static final ThreadLocal<UserAuth> USER_AUTH_THREAD_LOCAL = new ThreadLocal();

    public static UserAuth getAuthHandler() {
        UserAuth authHandler = USER_AUTH_THREAD_LOCAL.get();
        if (authHandler != null) {
            return authHandler;
        }
        return new Simple();
    }

    public static void removeAuthHandler() {
        USER_AUTH_THREAD_LOCAL.remove();
    }

    public static void setAuthHandler(UserAuth authHandler) {
        USER_AUTH_THREAD_LOCAL.set(authHandler);
    }

    private UserHandlerBuilder() {
    }
}

