/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StorageHandlerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StorageHandlerBuilder.class);
    private static final ThreadLocal<StorageHandler> STORAGE_HANDLER_THREAD_LOCAL = new ThreadLocal();

    public static StorageHandler getStorageHandler() throws IOException {
        StorageHandler storageHandler = STORAGE_HANDLER_THREAD_LOCAL.get();
        if (storageHandler != null) {
            return storageHandler;
        }
        LOG.error("No Storage Handler Configured.");
        throw new IOException("Invalid Handler Configuration");
    }

    public static void removeStorageHandler() {
        STORAGE_HANDLER_THREAD_LOCAL.remove();
    }

    public static void setStorageHandler(StorageHandler storageHandler) {
        STORAGE_HANDLER_THREAD_LOCAL.set(storageHandler);
    }

    private StorageHandlerBuilder() {
    }
}

